/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import org.maxkey.crypto.cert.StringUtil;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.impl.EntityDescriptorImpl;
import org.opensaml.saml2.metadata.impl.IDPSSODescriptorImpl;
import org.opensaml.saml2.metadata.impl.SPSSODescriptorImpl;
import org.opensaml.saml2.metadata.provider.DOMMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilesystemMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetadataDescriptorUtil {
    private static MetadataDescriptorUtil instance = null;
    private static final Logger logger = LoggerFactory.getLogger(MetadataDescriptorUtil.class);

    public MetadataDescriptorUtil() {
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static synchronized MetadataDescriptorUtil getInstance() {
        if (instance == null) {
            instance = new MetadataDescriptorUtil();
            logger.debug("getInstance() new ConfigFile instance");
        }
        return instance;
    }

    public EntityDescriptor getEntityDescriptor(File file) throws Exception {
        try {
            FilesystemMetadataProvider filesystemMetadataProvider = new FilesystemMetadataProvider(file);
            filesystemMetadataProvider.setRequireValidMetadata(true);
            filesystemMetadataProvider.setParserPool((ParserPool)new BasicParserPool());
            filesystemMetadataProvider.initialize();
            EntityDescriptorImpl entityDescriptor = (EntityDescriptorImpl)filesystemMetadataProvider.getMetadata();
            return entityDescriptor;
        }
        catch (MetadataProviderException e) {
            logger.error("\u5143\u6570\u636e\u89e3\u6790\u51fa\u9519", (Throwable)e);
            throw new Exception("\u5143\u6570\u636e\u6587\u4ef6\u89e3\u6790\u51fa\u9519", e);
        }
    }

    public EntityDescriptor getEntityDescriptor(InputStream inputStream) throws Exception {
        BasicParserPool basicParserPool = new BasicParserPool();
        basicParserPool.setNamespaceAware(true);
        try {
            Document inMetadataDoc = basicParserPool.parse(inputStream);
            Element metadataRoot = inMetadataDoc.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(metadataRoot);
            XMLObject xMLObject = unmarshaller.unmarshall(metadataRoot);
            EntityDescriptorImpl entityDescriptor = (EntityDescriptorImpl)xMLObject;
            return entityDescriptor;
        }
        catch (XMLParserException e) {
            logger.error("\u5143\u6570\u636e\u89e3\u6790\u51fa\u9519", (Throwable)e);
            throw new Exception("\u5143\u6570\u636e\u6587\u4ef6\u89e3\u6790\u51fa\u9519", e);
        }
        catch (UnmarshallingException e) {
            logger.error("\u5143\u6570\u636e\u89e3\u6790\u51fa\u9519", (Throwable)e);
            throw new Exception("\u5143\u6570\u636e\u6587\u4ef6\u89e3\u6790\u51fa\u9519", e);
        }
    }

    public EntityDescriptor getEntityDescriptor(String strMetadata) throws Exception {
        InputStream inputStream = StringUtil.String2InputStream((String)strMetadata);
        return this.getEntityDescriptor(inputStream);
    }

    public EntityDescriptor getEntityDescriptor(Element elementMetadata) throws Exception {
        try {
            DOMMetadataProvider dOMMetadataProvider = new DOMMetadataProvider(elementMetadata);
            dOMMetadataProvider.setRequireValidMetadata(true);
            dOMMetadataProvider.setParserPool((ParserPool)new BasicParserPool());
            dOMMetadataProvider.initialize();
            EntityDescriptorImpl entityDescriptor = (EntityDescriptorImpl)dOMMetadataProvider.getMetadata();
            return entityDescriptor;
        }
        catch (MetadataProviderException e) {
            logger.error("\u5143\u6570\u636e\u89e3\u6790\u51fa\u9519", (Throwable)e);
            throw new Exception("\u5143\u6570\u636e\u89e3\u6790\u51fa\u9519", e);
        }
    }

    public static void main(String[] args) throws Exception, ConfigurationException, FileNotFoundException {
        File file = new File("d:\\SAMLSP-00D90000000hf9n.xml");
        DefaultBootstrap.bootstrap();
        EntityDescriptor entityDescriptor = MetadataDescriptorUtil.getInstance().getEntityDescriptor(file);
        List listRoleDescriptor = entityDescriptor.getRoleDescriptors();
        for (RoleDescriptor roleDescriptor : listRoleDescriptor) {
            IDPSSODescriptorImpl iDPSSODescriptorImpl;
            if (roleDescriptor instanceof IDPSSODescriptorImpl) {
                iDPSSODescriptorImpl = (IDPSSODescriptorImpl)roleDescriptor;
                continue;
            }
            iDPSSODescriptorImpl = (SPSSODescriptorImpl)roleDescriptor;
        }
        FileInputStream in = new FileInputStream(file);
        EntityDescriptor entityDescriptor1 = MetadataDescriptorUtil.getInstance().getEntityDescriptor(in);
        SPSSODescriptor sPSSODescriptor = entityDescriptor1.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        System.out.println("ok :" + ((AssertionConsumerService)sPSSODescriptor.getAssertionConsumerServices().get(0)).getLocation());
    }
}

