/*
 * Decompiled with CFR 0.152.
 */
package org.maxkey.authz.saml20;

import java.security.KeyStore;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.velocity.app.VelocityEngine;
import org.maxkey.authz.saml.common.AuthnRequestInfo;
import org.maxkey.authz.saml.common.TrustResolver;
import org.maxkey.authz.saml20.BindingAdapter;
import org.maxkey.authz.saml20.ExtractBindingAdapter;
import org.maxkey.crypto.keystore.KeyStoreLoader;
import org.maxkey.crypto.keystore.KeyStoreUtil;
import org.maxkey.domain.apps.AppsSAML20Details;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.common.binding.encoding.SAMLMessageEncoder;
import org.opensaml.saml2.binding.encoding.HTTPPostEncoder;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.transport.OutTransport;
import org.opensaml.ws.transport.http.HttpServletResponseAdapter;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.KeyStoreCredentialResolver;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class PostBindingAdapter
implements BindingAdapter,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(PostBindingAdapter.class);
    static final String SAML_REQUEST_POST_PARAM_NAME = "SAMLRequest";
    static final String SAML_RESPONSE_POST_PARAM_NAME = "SAMLResponse";
    protected VelocityEngine velocityEngine;
    protected SAMLMessageEncoder encoder;
    protected String issuerEntityName;
    protected CredentialResolver credentialResolver;
    protected Credential signingCredential;
    protected Credential spSigningCredential;
    protected SecurityPolicyResolver securityPolicyResolver;
    protected ExtractBindingAdapter extractBindingAdapter;
    protected AuthnRequestInfo authnRequestInfo;
    protected String relayState;

    public PostBindingAdapter() {
    }

    public PostBindingAdapter(SAMLMessageDecoder decoder, String issuerEntityName) {
        this.issuerEntityName = issuerEntityName;
    }

    public PostBindingAdapter(String issuerEntityName, SecurityPolicyResolver securityPolicyResolver) {
        this.issuerEntityName = issuerEntityName;
        this.securityPolicyResolver = securityPolicyResolver;
    }

    @Required
    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    @Override
    public void sendSAMLMessage(SignableSAMLObject samlMessage, Endpoint endpoint, HttpServletRequest request, HttpServletResponse response) throws MessageEncodingException {
        HttpServletResponseAdapter outTransport = new HttpServletResponseAdapter(response, false);
        BasicSAMLMessageContext messageContext = new BasicSAMLMessageContext();
        if (this.relayState != null) {
            messageContext.setRelayState(this.relayState);
        }
        messageContext.setOutboundMessageTransport((OutTransport)outTransport);
        messageContext.setPeerEntityEndpoint(endpoint);
        messageContext.setOutboundSAMLMessage((SAMLObject)samlMessage);
        messageContext.setOutboundMessageIssuer(this.issuerEntityName);
        messageContext.setOutboundSAMLMessageSigningCredential(this.signingCredential);
        this.encoder.encode((MessageContext)messageContext);
    }

    public void buildCredentialResolver(CredentialResolver credentialResolver) throws Exception {
        this.credentialResolver = credentialResolver;
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIDCriteria(this.getKeyStoreLoader().getEntityName()));
        criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
        try {
            this.signingCredential = (Credential)credentialResolver.resolveSingle((Object)criteriaSet);
        }
        catch (SecurityException e) {
            logger.error("Credential Resolver error . ", (Throwable)e);
            throw new Exception(e);
        }
        Validate.notNull((Object)this.signingCredential);
    }

    public Credential buildSPSigningCredential() throws Exception {
        KeyStore trustKeyStore = KeyStoreUtil.bytes2KeyStore((byte[])this.getSaml20Details().getKeyStore(), (String)this.getKeyStoreLoader().getKeyStore().getType(), (String)this.getKeyStoreLoader().getKeystorePassword());
        TrustResolver trustResolver = new TrustResolver();
        KeyStoreCredentialResolver credentialResolver = trustResolver.buildKeyStoreCredentialResolver(trustKeyStore, this.getSaml20Details().getEntityId(), this.getKeyStoreLoader().getKeystorePassword());
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIDCriteria(this.getSaml20Details().getEntityId()));
        criteriaSet.add((Object)new UsageCriteria(UsageType.ENCRYPTION));
        try {
            this.spSigningCredential = credentialResolver.resolveSingle(criteriaSet);
        }
        catch (SecurityException e) {
            logger.error("Credential Resolver error . ", (Throwable)e);
            throw new Exception(e);
        }
        Validate.notNull((Object)this.spSigningCredential);
        return this.spSigningCredential;
    }

    public void afterPropertiesSet() throws Exception {
        this.encoder = new HTTPPostEncoder(this.velocityEngine, "/templates/saml2-post-binding.vm");
    }

    @Override
    public void setSecurityPolicyResolver(SecurityPolicyResolver securityPolicyResolver) {
        this.securityPolicyResolver = securityPolicyResolver;
    }

    public void setIssuerEntityName(String issuerEntityName) {
        this.issuerEntityName = issuerEntityName;
    }

    public KeyStoreLoader getKeyStoreLoader() {
        return this.extractBindingAdapter.getKeyStoreLoader();
    }

    @Override
    public Credential getSigningCredential() {
        return this.signingCredential;
    }

    public void setSigningCredential(Credential signingCredential) {
        this.signingCredential = signingCredential;
    }

    @Override
    public Credential getSpSigningCredential() {
        return this.spSigningCredential;
    }

    public void setSpSigningCredential(Credential spSigningCredential) {
        this.spSigningCredential = spSigningCredential;
    }

    @Override
    public AuthnRequestInfo getAuthnRequestInfo() {
        return this.authnRequestInfo;
    }

    @Override
    public void setAuthnRequestInfo(AuthnRequestInfo authnRequestInfo) {
        this.authnRequestInfo = authnRequestInfo;
    }

    @Override
    public void setRelayState(String relayState) {
        this.relayState = relayState;
    }

    @Override
    public void setExtractBindingAdapter(ExtractBindingAdapter extractBindingAdapter) {
        this.extractBindingAdapter = extractBindingAdapter;
        this.credentialResolver = extractBindingAdapter.getCredentialResolver();
        try {
            this.buildCredentialResolver(extractBindingAdapter.getCredentialResolver());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public AppsSAML20Details getSaml20Details() {
        return this.extractBindingAdapter.getSaml20Detail();
    }
}

