/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.dromara.mybatis.jpa.handler.SafeValueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionValue {
    private static final Logger logger = LoggerFactory.getLogger(ConditionValue.class);

    public static String valueOfList(List<?> listValue) {
        StringBuilder conditionArray = new StringBuilder();
        for (Object value : listValue) {
            if (!conditionArray.isEmpty()) {
                conditionArray.append(" , ");
            }
            conditionArray.append(SafeValueHandler.valueOfType(value));
        }
        return conditionArray.toString();
    }

    public static String valueOfArray(Object[] objects) {
        StringBuilder conditionArray = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            if (!conditionArray.isEmpty()) {
                conditionArray.append(" , ");
            }
            conditionArray.append(SafeValueHandler.valueOfType(objects[i]));
        }
        return conditionArray.toString();
    }

    public static String valueOfCollection(Collection<?> cObjects) {
        StringBuilder conditionArray = new StringBuilder();
        for (Object element : cObjects) {
            if (!conditionArray.isEmpty()) {
                conditionArray.append(" , ");
            }
            conditionArray.append(SafeValueHandler.valueOfType(element));
        }
        return conditionArray.toString();
    }

    public static String valueOfIterator(List<?> listValue) {
        StringBuilder conditionArray = new StringBuilder();
        for (Object element : listValue) {
            if (!conditionArray.isEmpty()) {
                conditionArray.append(" , ");
            }
            conditionArray.append(SafeValueHandler.valueOfType(element));
        }
        return conditionArray.toString();
    }

    public static String getCollectionValues(Object value) {
        logger.trace("expression Class() {} , getSimpleName {}", (Object)value.getClass().getCanonicalName(), (Object)value.getClass().getSimpleName());
        String collectionValues = "";
        if (value.getClass().isArray()) {
            Object[] objects = (Object[])value;
            Object object = objects[0];
            if (object instanceof Collection) {
                Collection cObjects = (Collection)object;
                logger.trace("objects[0] is Collection {}", (Object)cObjects);
                collectionValues = ConditionValue.valueOfCollection(cObjects);
            } else if (objects[0].getClass().isArray()) {
                objects = (Object[])objects[0];
                logger.trace("objects[0] is isArray {}", objects);
                collectionValues = ConditionValue.valueOfArray(objects);
            } else {
                logger.trace("not  isArray {}", objects);
                collectionValues = ConditionValue.valueOfArray(objects);
            }
        } else if (value.getClass().getCanonicalName().startsWith("java.util.ImmutableCollections")) {
            collectionValues = ConditionValue.valueOfIterator((List)value);
        } else if (value.getClass().getCanonicalName().equalsIgnoreCase("java.util.ArrayList")) {
            collectionValues = ConditionValue.valueOfList((ArrayList)value);
        } else if (value.getClass().getCanonicalName().equalsIgnoreCase("java.util.LinkedList")) {
            collectionValues = ConditionValue.valueOfList((LinkedList)value);
        }
        return collectionValues;
    }
}

