/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider.base;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.id.IdentifierGeneratorFactory;
import org.dromara.mybatis.jpa.metadata.ColumnMapper;
import org.dromara.mybatis.jpa.metadata.ColumnMetadata;
import org.dromara.mybatis.jpa.metadata.TableMetadata;
import org.dromara.mybatis.jpa.provider.base.DateConverter;
import org.dromara.mybatis.jpa.util.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(InsertProvider.class);

    public String insert(T entity) {
        List<ColumnMapper> listFields = ColumnMetadata.buildColumnMapper(entity.getClass());
        SQL sql = (SQL)new SQL().INSERT_INTO(TableMetadata.getTableName(entity.getClass()));
        if (logger.isTraceEnabled()) {
            for (ColumnMapper fieldColumnMapper : listFields) {
                logger.trace("fieldColumnMapper {} ", (Object)fieldColumnMapper);
            }
        }
        for (ColumnMapper fieldColumnMapper : listFields) {
            String columnName = fieldColumnMapper.getColumn();
            String fieldName = fieldColumnMapper.getField();
            String fieldType = fieldColumnMapper.getFieldType();
            Object fieldValue = BeanUtil.getValue(entity, fieldName);
            boolean isFieldValueNull = BeanUtil.isFieldBlank(fieldValue);
            if (!fieldColumnMapper.getColumnAnnotation().insertable()) continue;
            if (fieldColumnMapper.getColumnDefault() != null) {
                sql.VALUES(columnName, fieldColumnMapper.getColumnDefault().value());
                continue;
            }
            if (fieldColumnMapper.isLogicDelete()) {
                sql.VALUES(columnName, "'" + fieldColumnMapper.getSoftDelete().value() + "'");
                continue;
            }
            if (isFieldValueNull && !fieldColumnMapper.isGenerated()) {
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Field {} , Type {} , Value is null , Skiped ", (Object)String.format("%-30s", fieldName), (Object)String.format("%-30s", fieldType));
                continue;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Field {} , Type {} , Value {}", new Object[]{String.format("%-30s", fieldName), String.format("%-30s", fieldType), fieldValue});
            }
            if (fieldColumnMapper.isGenerated() && fieldColumnMapper.getTemporalAnnotation() != null) {
                sql.VALUES(columnName, "'" + DateConverter.convert(entity, fieldColumnMapper, false) + "'");
                continue;
            }
            if (fieldColumnMapper.isGenerated() && isFieldValueNull) {
                this.generatedValue(sql, entity, fieldColumnMapper);
                continue;
            }
            sql.VALUES(columnName, "#{%s}".formatted(fieldName));
        }
        logger.trace("Insert SQL : \n{}", (Object)sql);
        return sql.toString();
    }

    private void generatedValue(SQL sql, T entity, ColumnMapper fieldColumnMapper) {
        GeneratedValue generatedValue = fieldColumnMapper.getGeneratedValue();
        if (generatedValue == null || generatedValue.strategy() == GenerationType.AUTO) {
            String genValue = "";
            genValue = generatedValue == null ? IdentifierGeneratorFactory.generate("default") : (IdentifierGeneratorFactory.exists(generatedValue.generator()) ? IdentifierGeneratorFactory.generate(generatedValue.generator()) : IdentifierGeneratorFactory.generate("default"));
            if (fieldColumnMapper.getFieldType().equalsIgnoreCase("String")) {
                BeanUtil.set(entity, fieldColumnMapper.getField(), genValue);
            } else if (fieldColumnMapper.getFieldType().equalsIgnoreCase("Integer")) {
                BeanUtil.set(entity, fieldColumnMapper.getField(), Integer.valueOf(genValue));
            } else if (fieldColumnMapper.getFieldType().equalsIgnoreCase("Long")) {
                BeanUtil.set(entity, fieldColumnMapper.getField(), Long.valueOf(genValue));
            }
            sql.VALUES(fieldColumnMapper.getColumn(), "#{%s}".formatted(fieldColumnMapper.getField()));
        } else if (generatedValue.strategy() == GenerationType.SEQUENCE) {
            sql.VALUES(fieldColumnMapper.getColumn(), generatedValue.generator() + ".nextval");
        } else if (generatedValue.strategy() == GenerationType.IDENTITY || generatedValue.strategy() == GenerationType.TABLE) {
            // empty if block
        }
    }
}

