/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.metadata;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.metadata.ColumnMetadata;
import org.dromara.mybatis.jpa.metadata.MapperMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetadata {
    private static final Logger logger = LoggerFactory.getLogger(TableMetadata.class);
    static ConcurrentMap<String, String> tableNameMap = new ConcurrentHashMap<String, String>();

    public static SQL buildSelect(Class<?> entityClass) {
        ColumnMetadata.buildColumnMapper(entityClass);
        return (SQL)((SQL)new SQL().SELECT(ColumnMetadata.selectColumnMapper(entityClass))).FROM(TableMetadata.getTableName(entityClass) + " tmp_t");
    }

    public static SQL buildSelectCount(Class<?> entityClass) {
        ColumnMetadata.buildColumnMapper(entityClass);
        return (SQL)((SQL)new SQL().SELECT(" count(1) as _select_count ")).FROM(TableMetadata.getTableName(entityClass) + " tmp_t");
    }

    public static SQL buildSelect(Class<?> entityClass, boolean distinct) {
        ColumnMetadata.buildColumnMapper(entityClass);
        if (distinct) {
            return (SQL)((SQL)new SQL().SELECT_DISTINCT(ColumnMetadata.selectColumnMapper(entityClass))).FROM(TableMetadata.getTableName(entityClass) + " tmp_t");
        }
        return (SQL)((SQL)new SQL().SELECT(ColumnMetadata.selectColumnMapper(entityClass))).FROM(TableMetadata.getTableName(entityClass) + " tmp_t");
    }

    public static String getTableName(Class<?> entityClass) {
        String entityClassName = entityClass.getName();
        if (!tableNameMap.containsKey(entityClassName)) {
            logger.debug("entity Class Name {}", (Object)entityClassName);
            Object tableName = null;
            String schema = null;
            String catalog = null;
            Entity entity = entityClass.getAnnotation(Entity.class);
            logger.trace("entity {}", (Object)entity);
            Table table = entityClass.getAnnotation(Table.class);
            logger.trace("table {}", (Object)table);
            if (entity != null) {
                if (entity.name() != null && !entity.name().equals("")) {
                    tableName = entity.name();
                }
                if (table != null) {
                    if (table.name() != null && !table.name().equals("")) {
                        tableName = table.name();
                    }
                    if (table.schema() != null && !table.schema().equals("")) {
                        schema = table.schema();
                        logger.trace("schema {}", (Object)schema);
                    }
                    if (table.catalog() != null && !table.catalog().equals("")) {
                        catalog = table.catalog();
                        logger.trace("catalog {}", (Object)catalog);
                    }
                }
                if (tableName == null) {
                    tableName = entityClass.getSimpleName();
                }
                if (schema != null) {
                    tableName = schema + "." + (String)tableName;
                }
                if (catalog != null) {
                    tableName = catalog + "." + (String)tableName;
                }
            }
            tableName = MapperMetadata.tableOrColumnCaseConverter(tableName);
            tableName = MapperMetadata.tableOrColumnEscape((String)tableName);
            tableNameMap.put(entityClassName, (String)tableName);
            logger.trace("Table Name {}", tableName);
        }
        return (String)tableNameMap.get(entityClassName);
    }
}

