/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.crypto.utils;

import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.dromara.mybatis.jpa.crypto.utils.HexUtils;
import org.dromara.mybatis.jpa.util.StringGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReciprocalUtils {
    private static final Logger logger = LoggerFactory.getLogger(ReciprocalUtils.class);
    public static final String DEFAULT_KEY = "l0JqT7NvIzP9oRaG4kFc1QmD_bWu3x8E5yS2h6";

    public static byte[] encode(byte[] simpleBytes, SecretKey secretKey, String algorithm) {
        byte[] byteFinal = null;
        try {
            Cipher ecipher = Cipher.getInstance(secretKey.getAlgorithm());
            ecipher.init(1, secretKey);
            byteFinal = ecipher.doFinal(simpleBytes);
            return byteFinal;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encode(String simple, String secretKey, String algorithm) {
        if (StringUtils.isNotBlank((CharSequence)simple) && ReciprocalUtils.keyLengthCheck(secretKey, algorithm)) {
            SecretKey key = ReciprocalUtils.generatorKey(secretKey, algorithm);
            return ReciprocalUtils.encode(simple.getBytes(StandardCharsets.UTF_8), key, algorithm);
        }
        return null;
    }

    public static byte[] decoder(byte[] ciphersBytes, SecretKey secretKey, String algorithm) {
        byte[] byteFinal = null;
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(2, secretKey);
            byteFinal = cipher.doFinal(ciphersBytes);
            return byteFinal;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decoder(byte[] ciphersBytes, String secretKey, String algorithm) {
        if (ReciprocalUtils.keyLengthCheck(secretKey, algorithm)) {
            SecretKey key = ReciprocalUtils.generatorKey(secretKey, algorithm);
            byte[] decoderBytes = ReciprocalUtils.decoder(ciphersBytes, key, algorithm);
            return decoderBytes == null ? null : new String(decoderBytes, StandardCharsets.UTF_8);
        }
        return null;
    }

    public static String generatorDefaultKey(String secretKey, String algorithm) {
        try {
            secretKey = (String)secretKey + DEFAULT_KEY;
            if (algorithm.equals("DES")) {
                secretKey = ((String)secretKey).substring(0, 8);
            } else if (algorithm.equals("AES") || algorithm.equals("Blowfish")) {
                secretKey = ((String)secretKey).substring(0, 16);
            } else if (algorithm.equals("DESede")) {
                secretKey = ((String)secretKey).substring(0, 24);
            }
            return secretKey;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static SecretKey generatorKey(String secretKey, String algorithm) {
        try {
            return new SecretKeySpec(secretKey.getBytes(), algorithm);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encode2Hex(String simple, String secretKey, String algorithm) {
        if (ReciprocalUtils.keyLengthCheck(secretKey, algorithm)) {
            byte[] cipher = ReciprocalUtils.encode(simple, secretKey, algorithm);
            return HexUtils.bytes2HexString(cipher);
        }
        return null;
    }

    public static String decoderHex(String ciphers, String secretKey, String algorithm) {
        if (StringUtils.isBlank((CharSequence)ciphers)) {
            return "";
        }
        if (ReciprocalUtils.keyLengthCheck(secretKey, algorithm)) {
            byte[] byteSimple = HexUtils.hex2Bytes(ciphers);
            return ReciprocalUtils.decoder(byteSimple, secretKey, algorithm);
        }
        return null;
    }

    public static String encode2Hex(String simple, String secretKey) {
        String key = ReciprocalUtils.generatorDefaultKey(secretKey + DEFAULT_KEY, "DESede");
        return ReciprocalUtils.encode2Hex(simple, key, "DESede");
    }

    public static String decoderHex(String ciphers, String secretKey) {
        String key = ReciprocalUtils.generatorDefaultKey(secretKey + DEFAULT_KEY, "DESede");
        return ReciprocalUtils.decoderHex(ciphers, key, "DESede");
    }

    private static boolean keyLengthCheck(String secretKey, String algorithm) {
        boolean lengthCheck = false;
        if (algorithm.equals("DES")) {
            if (secretKey.length() == 8) {
                lengthCheck = true;
            } else {
                logger.error("DES key length is  {} ,must lequal 8", (Object)secretKey.getBytes().length);
            }
        } else if (algorithm.equals("DESede")) {
            if (secretKey.length() == 24) {
                lengthCheck = true;
            } else {
                logger.error("DESede key length is  {} ,must equal 24", (Object)secretKey.getBytes().length);
            }
        } else if (algorithm.equals("AES")) {
            if (secretKey.length() == 16) {
                lengthCheck = true;
            } else {
                logger.error("AES key length is  {} ,must equal 16", (Object)secretKey.getBytes().length);
            }
        } else if (algorithm.equals("Blowfish")) {
            if (secretKey.length() <= 16) {
                lengthCheck = true;
            } else {
                logger.error("Blowfish key length is {} ,must be less then 16", (Object)secretKey.getBytes().length);
            }
        }
        return lengthCheck;
    }

    public static String cutSecretKey(String secretKey, String algorithm) {
        if (algorithm.equals("DES")) {
            return secretKey.substring(0, 8);
        }
        if (algorithm.equals("DESede")) {
            return secretKey.substring(0, 24);
        }
        if (algorithm.equals("AES")) {
            return secretKey.substring(0, 16);
        }
        if (algorithm.equals("Blowfish")) {
            return secretKey.substring(0, 16);
        }
        if (algorithm.equals("SM4")) {
            return secretKey.substring(0, 32);
        }
        return secretKey;
    }

    public static String aesEncode(String simple, String secretKey) {
        return ReciprocalUtils.encode2Hex(simple, secretKey, "AES");
    }

    public static String aesDecoder(String ciphers, String secretKey) {
        return ReciprocalUtils.decoderHex(ciphers, secretKey, "AES");
    }

    public static String generateKey(String algorithm) {
        if (algorithm.equals("DES")) {
            return new StringGenerator(8).randomGenerate();
        }
        if (algorithm.equals("AES")) {
            return new StringGenerator(16).randomGenerate();
        }
        if (algorithm.equals("Blowfish")) {
            return new StringGenerator(16).randomGenerate();
        }
        if (algorithm.equals("DESede")) {
            return new StringGenerator(24).randomGenerate();
        }
        return new StringGenerator().uniqueGenerate();
    }

    public final class Algorithm {
        public static final String DES = "DES";
        public static final String TRIPLE_DES = "DESede";
        public static final String BLOWFISH = "Blowfish";
        public static final String AES = "AES";
        public static final String SM4 = "SM4";
    }
}

