/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.interceptor;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.executor.statement.PreparedStatementHandler;
import org.apache.ibatis.executor.statement.SimpleStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.RowBounds;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.interceptor.AbstractStatementHandlerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class}), @Signature(type=StatementHandler.class, method="parameterize", args={Statement.class}), @Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class AllStatementHandlerInterceptor
extends AbstractStatementHandlerInterceptor
implements Interceptor {
    private static Logger logger = LoggerFactory.getLogger(AllStatementHandlerInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Method m = invocation.getMethod();
        if ("prepare".equals(m.getName())) {
            return this.prepare(invocation);
        }
        if ("parameterize".equals(m.getName())) {
            return this.parameterize(invocation);
        }
        if ("handleResultSets".equals(m.getName())) {
            return this.handleResultSets(invocation);
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Object prepare(Invocation invocation) throws Throwable {
        StatementHandler statement = this.getStatementHandler(invocation);
        if (statement instanceof SimpleStatementHandler || statement instanceof PreparedStatementHandler) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)statement);
            Object parameterObject = metaObject.getValue("parameterHandler.parameterObject");
            BoundSql boundSql = statement.getBoundSql();
            String sql = boundSql.getSql();
            logger.debug("startsWith select : {} , prepare  boundSql : {}", (Object)this.isSelectSql(sql), (Object)sql);
            if (this.isSelectSql(sql) && parameterObject instanceof JpaEntity) {
                JpaEntity jpaEntity = (JpaEntity)parameterObject;
                if (statement instanceof SimpleStatementHandler) {
                    sql = this.dialect.getLimitString(sql, jpaEntity);
                } else if (statement instanceof PreparedStatementHandler) {
                    sql = this.dialect.getPreparedStatementLimitString(sql, jpaEntity);
                }
            }
            metaObject.setValue("boundSql.sql", (Object)sql);
        }
        return invocation.proceed();
    }

    private Object parameterize(Invocation invocation) throws Throwable {
        Statement statement = (Statement)invocation.getArgs()[0];
        if (statement instanceof PreparedStatement) {
            PreparedStatement ps = (PreparedStatement)statement;
            StatementHandler statementHandler = this.getStatementHandler(invocation);
            RowBounds rowBounds = this.getRowBounds(statementHandler);
            logger.debug("rowBounds {}", (Object)rowBounds);
            MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
            Object parameterObject = metaObject.getValue("parameterHandler.parameterObject");
            BoundSql boundSql = statementHandler.getBoundSql();
            if (this.isSelectSql(boundSql.getSql()) && parameterObject instanceof JpaEntity) {
                JpaEntity jpaEntity = (JpaEntity)parameterObject;
                List pms = boundSql.getParameterMappings();
                logger.debug("ParameterMapping {}", (Object)pms);
                int parameterSize = pms.size();
                this.dialect.setLimitParamters(ps, parameterSize, jpaEntity);
            }
        }
        return invocation.proceed();
    }

    private Object handleResultSets(Invocation invocation) throws Throwable {
        return invocation.proceed();
    }

    private boolean isSelectSql(String sql) {
        return sql.toLowerCase().trim().startsWith("select".toLowerCase());
    }
}

