/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.hostchooser;

import com.highgo.jdbc.core.Utils;
import com.highgo.jdbc.hostchooser.PgHostSpec;
import com.highgo.jdbc.util.HostSpec;
import com.highgo.jdbc.util.JDBCXmlUtils;
import com.highgo.jdbc.util.PSQLException;
import com.highgo.jdbc.util.PSQLState;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PgHostSpecFactory {
    private static volatile PgHostSpecFactory instance;
    private static final int DEFAULT_WEIGHT = 0;
    private List<PgHostSpec> pgHostSpecs = Collections.synchronizedList(new ArrayList());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PgHostSpecFactory getInstance() {
        if (instance != null) return instance;
        Class<PgHostSpecFactory> clazz = PgHostSpecFactory.class;
        synchronized (PgHostSpecFactory.class) {
            if (instance != null) return instance;
            instance = new PgHostSpecFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public List<PgHostSpec> getPgHostSpecs() {
        return this.pgHostSpecs;
    }

    public void setPgHostSpecs(List<PgHostSpec> pgHostSpecs) {
        this.pgHostSpecs = pgHostSpecs;
    }

    public synchronized void initPgHostSpec(String fileName) throws PSQLException {
        if (this.getPgHostSpecs().size() == 0) {
            if (fileName.trim().startsWith("/")) {
                try {
                    fileName = new File("").getCanonicalPath() + fileName;
                }
                catch (IOException e) {
                    throw new PSQLException(e.getMessage(), PSQLState.UNKNOWN_STATE);
                }
            }
            this.setPgHostSpecs(JDBCXmlUtils.getPgHostSpecs(fileName));
        }
    }

    public PgHostSpec getPgHostSpec(HostSpec hostSpec) {
        String id = Utils.jointID(hostSpec);
        for (PgHostSpec pgHostSpec : this.pgHostSpecs) {
            if (!id.equals(pgHostSpec.getId())) continue;
            return pgHostSpec;
        }
        PgHostSpec pgHostSpec = new PgHostSpec(hostSpec.getHost(), hostSpec.getPort() + "", 0);
        this.addPgHostSpec(pgHostSpec);
        return pgHostSpec;
    }

    public void increaseConnect(HostSpec hostSpec) {
        PgHostSpec pgHostSpec = this.getPgHostSpec(hostSpec);
        if (pgHostSpec != null) {
            pgHostSpec.increaseConnect();
        }
    }

    public void reduceConnect(HostSpec hostSpec) {
        PgHostSpec pgHostSpec = this.getPgHostSpec(hostSpec);
        if (pgHostSpec != null) {
            pgHostSpec.reduceConnect();
        }
    }

    public void addPgHostSpec(String id, int weight) {
        if (!this.isExistPgHostSpec(id)) {
            this.pgHostSpecs.add(new PgHostSpec(id, weight));
        }
    }

    public void addPgHostSpec(PgHostSpec pgHostSpec) {
        if (!this.isExistPgHostSpec(pgHostSpec)) {
            this.pgHostSpecs.add(pgHostSpec);
        }
    }

    private boolean isExistPgHostSpec(PgHostSpec pgHostSpec) {
        return this.isExistPgHostSpec(pgHostSpec.getId());
    }

    private boolean isExistPgHostSpec(String id) {
        boolean isExist = false;
        for (PgHostSpec pgHostSpec : this.pgHostSpecs) {
            if (!id.equals(pgHostSpec.getId())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public String showList() {
        StringBuilder sb = new StringBuilder("============show database list=============\r\n");
        for (PgHostSpec pgHostSpec : this.pgHostSpecs) {
            sb.append(pgHostSpec.toString() + "\r\n");
        }
        return sb.toString();
    }
}

