/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa;

import java.util.Collections;
import java.util.List;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.mybatis.jpa.StatementHandlerInterceptor;
import org.apache.mybatis.jpa.dialect.Dialect;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisSessionFactoryBean
extends SqlSessionFactoryBean {
    protected Logger _logger = LoggerFactory.getLogger(MyBatisSessionFactoryBean.class);
    private List<Interceptor> interceptors = Collections.emptyList();
    private int timeout = 30;
    private String dialect = "mysql";

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws Exception {
        SqlSessionFactory factory = super.buildSqlSessionFactory();
        Configuration config = factory.getConfiguration();
        this._logger.debug("buildSqlSessionFactory : {}", (Object)config.toString());
        for (Interceptor interceptor : this.interceptors) {
            config.addInterceptor(interceptor);
        }
        StatementHandlerInterceptor statementHandlerInterceptor = new StatementHandlerInterceptor();
        statementHandlerInterceptor.setDialectString(Dialect.getDialect(this.dialect));
        config.addInterceptor((Interceptor)statementHandlerInterceptor);
        if (config.getDefaultStatementTimeout() == null || config.getDefaultStatementTimeout() == 0) {
            this._logger.debug("set StatementTimeout as default");
            config.setDefaultStatementTimeout(Integer.valueOf(this.timeout));
        }
        this._logger.debug("DefaultStatementTimeout : {}", (Object)config.getDefaultStatementTimeout());
        this._logger.debug("MappedStatementNames {}", (Object)config.getMappedStatementNames());
        return factory;
    }

    public SqlSessionFactory build() throws Exception {
        return this.buildSqlSessionFactory();
    }
}

