/*
 * Decompiled with CFR 0.152.
 */
package com.highgo.jdbc.util;

import com.highgo.jdbc.PGProperty;
import com.highgo.jdbc.hostchooser.PgHostSpec;
import com.highgo.jdbc.util.PSQLException;
import com.highgo.jdbc.util.PSQLState;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JDBCXmlUtils {
    private static final String XML_CLUSTER_NAME = "cluster";
    private static final String XML_WEIGHT_NAME = "weight";
    private static final String XML_HOST_NAME = "host";
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final String XML_PORT_NAME = "port";
    private static final String DEFAULT_PORT = "5866";

    public static List<PgHostSpec> getPgHostSpecs(String fileName) throws PSQLException {
        ArrayList<PgHostSpec> res = new ArrayList<PgHostSpec>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(fileName);
            NodeList clusterList = document.getElementsByTagName(XML_CLUSTER_NAME);
            for (int i = 0; i < clusterList.getLength(); ++i) {
                Node cluster = clusterList.item(i);
                NodeList databaseList = cluster.getChildNodes();
                for (int j = 0; j < databaseList.getLength(); ++j) {
                    Node database = databaseList.item(j);
                    if (database.getNodeType() != 1) continue;
                    String str = "0";
                    try {
                        NamedNodeMap attrs = database.getAttributes();
                        if (attrs.getNamedItem(XML_WEIGHT_NAME) != null) {
                            str = attrs.getNamedItem(XML_WEIGHT_NAME).getNodeValue();
                        }
                        int weight = Integer.parseInt(str);
                        NodeList properties = database.getChildNodes();
                        String host = DEFAULT_HOST;
                        String port = DEFAULT_PORT;
                        for (int m = 0; m < properties.getLength(); ++m) {
                            Node property = properties.item(m);
                            if (property.getNodeType() != 1) continue;
                            String name = property.getNodeName();
                            String value = property.getFirstChild().getNodeValue();
                            if (XML_HOST_NAME.equals(name)) {
                                host = value;
                                continue;
                            }
                            if (XML_PORT_NAME.equals(name)) {
                                port = value;
                                continue;
                            }
                            throw new PSQLException("Invalid property name : " + name, PSQLState.INVALID_PARAMETER_VALUE);
                        }
                        PgHostSpec pgHostSpec = new PgHostSpec(host, port, weight);
                        res.add(pgHostSpec);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new PSQLException("Invalid weight value :" + str + ", this should be a int number", PSQLState.INVALID_PARAMETER_VALUE);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PSQLException("error with " + PGProperty.JDBC_XML.getName() + " file :" + e.getMessage(), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return res;
    }
}

