/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.feature;

import com.taobao.api.ApiException;
import com.taobao.api.ApiRuleException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoBatchRequest;
import com.taobao.api.TaobaoBatchResponse;
import com.taobao.api.TaobaoParser;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.TaobaoResponse;
import com.taobao.api.internal.parser.json.ObjectJsonParser;
import com.taobao.api.internal.parser.xml.ObjectXmlParser;
import com.taobao.api.internal.util.HttpResponseData;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.TaobaoLogger;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.internal.util.WebUtils;
import com.taobao.api.internal.util.WebV2Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatchFeature {
    public static final String BATCH_API_HEADER_SPLIT = "top-api-separator";
    public static final String BATCH_API_PUBLIC_PARAMETER = "#PUBLIC#";
    public static final String BATCH_API_DEFAULT_SPLIT = "\r\n-S-\r\n";
    private String batchServerUrl;
    private String batchApiSeparator;
    private DefaultTaobaoClient client;

    public void init(String batchServerUrl, DefaultTaobaoClient client) {
        this.batchServerUrl = batchServerUrl;
        this.client = client;
    }

    public <T extends TaobaoResponse> T execute(TaobaoRequest<T> request, String session) throws ApiException {
        if (request instanceof TaobaoBatchRequest) {
            return this._execute(request, session);
        }
        return this.clientExecute(request, session);
    }

    private <T extends TaobaoResponse> T _execute(TaobaoRequest<T> tRequest, String session) throws ApiException {
        TaobaoBatchRequest batchRequest = (TaobaoBatchRequest)tRequest;
        long start = System.currentTimeMillis();
        List<TaobaoRequest<?>> requestList = batchRequest.getRequestList();
        if (requestList == null || requestList.isEmpty()) {
            throw new ApiException("40", "client-error:api request list is empty");
        }
        if (this.client.isNeedCheckRequest() && batchRequest.getPublicParams().isEmpty()) {
            for (int i = 0; i < requestList.size(); ++i) {
                try {
                    requestList.get(i).check();
                    continue;
                }
                catch (ApiRuleException e) {
                    return (T)new TaobaoBatchResponse(e.getErrCode(), "API NO. " + (i + 1) + ": " + e.getErrMsg());
                }
            }
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        TaobaoHashMap protocalMustParams = new TaobaoHashMap();
        protocalMustParams.put("v", "2.0");
        protocalMustParams.put("app_key", this.client.getAppKey());
        Long timestamp = batchRequest.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put("timestamp", (Object)new Date(timestamp));
        requestHolder.setProtocalMustParams(protocalMustParams);
        TaobaoHashMap protocalOptParams = new TaobaoHashMap();
        protocalOptParams.put("format", this.client.getFormat());
        protocalOptParams.put("sign_method", this.client.getSignMethod());
        protocalOptParams.put("session", session);
        protocalOptParams.put("partner_id", this.client.getSdkVersion());
        protocalOptParams.put("target_app_key", batchRequest.getTargetAppKey());
        if ("json".equals(this.client.getFormat()) && this.client.isUseSimplifyJson()) {
            protocalOptParams.put("simplify", Boolean.TRUE.toString());
        }
        requestHolder.setProtocalOptParams(protocalOptParams);
        String separator = BATCH_API_DEFAULT_SPLIT;
        if (this.batchApiSeparator != null) {
            separator = this.batchApiSeparator;
            batchRequest.putHeaderParam(BATCH_API_HEADER_SPLIT, separator);
        }
        if (this.client.isUseGzipEncoding()) {
            batchRequest.putHeaderParam("Accept-Encoding", "gzip");
        }
        try {
            if (batchRequest.getPublicMethod() != null) {
                batchRequest.addPublicParam("method", batchRequest.getPublicMethod());
            } else if (this.isSameRequest(requestList)) {
                batchRequest.addPublicParam("method", requestList.get(0).getApiMethodName());
            }
            StringBuilder requestBody = new StringBuilder();
            String publicParamStr = WebUtils.buildQuery(batchRequest.getPublicParams(), "UTF-8");
            if (!StringUtils.isEmpty(publicParamStr)) {
                requestBody.append(BATCH_API_PUBLIC_PARAMETER).append(publicParamStr).append(separator);
            }
            for (int i = 0; i < requestList.size(); ++i) {
                String apiParamStr;
                TaobaoRequest<?> request = requestList.get(i);
                request.setBatchApiOrder(i);
                Map<String, String> apiParams = request.getTextParams();
                if (request.getApiMethodName() != null && !request.getApiMethodName().equals(batchRequest.getPublicMethod())) {
                    apiParams.put("method", request.getApiMethodName());
                }
                if (request.getBatchApiSession() != null) {
                    apiParams.put("session", request.getBatchApiSession());
                }
                if (request.getTargetAppKey() != null) {
                    apiParams.put("target_app_key", request.getTargetAppKey());
                }
                if (StringUtils.isEmpty(apiParamStr = WebUtils.buildQuery(apiParams, "UTF-8"))) {
                    apiParamStr = "N";
                }
                requestBody.append(apiParamStr);
                if (i == requestList.size() - 1) continue;
                requestBody.append(separator);
            }
            String apiBody = requestBody.toString();
            protocalMustParams.put("sign", TaobaoUtils.signTopRequestWithBody(requestHolder, apiBody, this.client.getAppSecret(), this.client.getSignMethod()));
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            String fullUrl = WebUtils.buildRequestUrl(this.batchServerUrl, sysMustQuery, sysOptQuery);
            HttpResponseData data = WebV2Utils.doPost(fullUrl, apiBody, "UTF-8", this.client.getConnectTimeout(), this.client.getReadTimeout(), batchRequest.getHeaderMap());
            requestHolder.setResponseBody(data.getBody());
        }
        catch (IOException e) {
            TaobaoLogger.logApiError(this.client.getAppKey(), "BatchApi", this.batchServerUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new ApiException(e);
        }
        ArrayList parserList = new ArrayList();
        if (this.client.isNeedEnableParser()) {
            if ("xml".equals(this.client.getFormat())) {
                for (int i = 0; i < requestList.size(); ++i) {
                    parserList.add(new ObjectXmlParser(requestList.get(i).getResponseClass()));
                }
            } else {
                for (int i = 0; i < requestList.size(); ++i) {
                    parserList.add(new ObjectJsonParser(requestList.get(i).getResponseClass(), this.client.isUseSimplifyJson()));
                }
            }
        }
        TaobaoBatchResponse batchResponse = new TaobaoBatchResponse();
        batchResponse.setBody(requestHolder.getResponseBody());
        String[] responseArray = batchResponse.getBody().split(separator);
        if (responseArray.length > 0 && responseArray.length != requestList.size()) {
            if (this.client.isNeedEnableParser()) {
                TaobaoResponse tRsp = (TaobaoResponse)((TaobaoParser)parserList.get(0)).parse(responseArray[0], "top");
                batchResponse.setErrorCode(tRsp.getErrorCode());
                batchResponse.setMsg(tRsp.getMsg());
                batchResponse.setSubCode(tRsp.getSubCode());
                batchResponse.setSubMsg(tRsp.getSubMsg());
            } else {
                batchResponse.setMsg("batch api call fail");
            }
            return (T)batchResponse;
        }
        for (int i = 0; i < responseArray.length; ++i) {
            TaobaoResponse tRsp = null;
            if (this.client.isNeedEnableParser()) {
                tRsp = (TaobaoResponse)((TaobaoParser)parserList.get(i)).parse(responseArray[i], "top");
                tRsp.setBody(responseArray[i]);
            } else {
                try {
                    tRsp = (TaobaoResponse)requestList.get(i).getResponseClass().newInstance();
                    tRsp.setBody(responseArray[i]);
                }
                catch (Exception e) {
                    throw new ApiException(e);
                }
            }
            tRsp.setParams(requestList.get(i).getTextParams());
            batchResponse.addResponse(tRsp);
        }
        if (!batchResponse.isSuccess()) {
            TaobaoLogger.logApiError(this.client.getAppKey(), "BatchApi", this.batchServerUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, batchResponse.getBody());
        }
        return (T)batchResponse;
    }

    private boolean isSameRequest(List<TaobaoRequest<?>> requestList) {
        if (requestList != null && requestList.size() > 1) {
            String firstMethod = requestList.get(0).getApiMethodName();
            for (int i = 1; i < requestList.size(); ++i) {
                String currentMethod = requestList.get(i).getApiMethodName();
                if (firstMethod.equals(currentMethod)) continue;
                return false;
            }
        }
        return true;
    }

    public void setBatchApiSeparator(String batchApiSeparator) {
        this.batchApiSeparator = batchApiSeparator;
    }

    public String getBatchServerUrl() {
        return this.batchServerUrl;
    }

    public void setBatchServerUrl(String batchServerUrl) {
        this.batchServerUrl = batchServerUrl;
    }

    public abstract <T extends TaobaoResponse> T clientExecute(TaobaoRequest<T> var1, String var2) throws ApiException;
}

