/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.provider;

import java.util.ArrayList;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.dromara.mybatis.jpa.entity.JpaEntity;
import org.dromara.mybatis.jpa.meta.FieldColumnMapper;
import org.dromara.mybatis.jpa.meta.FieldMetadata;
import org.dromara.mybatis.jpa.meta.MapperMetadata;
import org.dromara.mybatis.jpa.meta.TableMetadata;
import org.dromara.mybatis.jpa.query.LambdaQuery;
import org.dromara.mybatis.jpa.query.LambdaQueryBuilder;
import org.dromara.mybatis.jpa.query.Query;
import org.dromara.mybatis.jpa.query.QueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteProvider<T extends JpaEntity> {
    static final Logger logger = LoggerFactory.getLogger(DeleteProvider.class);

    public String deleteById(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        FieldMetadata.buildColumnList(entityClass);
        String tableName = TableMetadata.getTableName(entityClass);
        if (MapperMetadata.getSqlsMap().containsKey(tableName + "_REMOVE_SQL")) {
            return (String)MapperMetadata.getSqlsMap().get(tableName + "_REMOVE_SQL");
        }
        String idValue = (String)parametersMap.get("id");
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        FieldColumnMapper partitionKeyColumnMapper = FieldMetadata.getPartitionKey(entityClass);
        FieldColumnMapper idFieldColumnMapper = FieldMetadata.getIdColumn(entityClass);
        SQL sql = (SQL)new SQL().DELETE_FROM(tableName);
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE(" %s = #{%s} and %s = '%s' ".formatted(partitionKeyColumnMapper.getColumnName(), partitionKeyValue, idFieldColumnMapper.getColumnName(), idValue));
        } else {
            sql.WHERE("%s = '%s'".formatted(idFieldColumnMapper.getColumnName(), idValue));
        }
        String deleteSql = sql.toString();
        MapperMetadata.getSqlsMap().put(tableName + "_REMOVE_SQL", deleteSql);
        logger.trace("Delete SQL \n{}", (Object)deleteSql);
        return deleteSql;
    }

    public String batchDelete(Map<String, Object> parametersMap) {
        Class entityClass = (Class)parametersMap.get("entityClass");
        FieldMetadata.buildColumnList(entityClass);
        String tableName = TableMetadata.getTableName(entityClass);
        ArrayList idValues = (ArrayList)parametersMap.get("idList");
        StringBuffer keyValue = new StringBuffer();
        for (String value : idValues) {
            if (value.trim().length() <= 0) continue;
            keyValue.append(",'").append(value).append("'");
            logger.trace("logic delete by id {}", (Object)value);
        }
        String keyValues = keyValue.substring(1).replace(";", "");
        String partitionKeyValue = (String)parametersMap.get("partitionKey");
        FieldColumnMapper partitionKeyColumnMapper = FieldMetadata.getPartitionKey(entityClass);
        FieldColumnMapper idFieldColumnMapper = FieldMetadata.getIdColumn(entityClass);
        SQL sql = (SQL)new SQL().DELETE_FROM(tableName);
        if (partitionKeyColumnMapper != null && partitionKeyValue != null) {
            sql.WHERE("%s = #{%s} and %s  in ( %s )".formatted(partitionKeyColumnMapper.getColumnName(), partitionKeyValue, idFieldColumnMapper.getColumnName(), idFieldColumnMapper.getFieldName()));
        } else {
            sql.WHERE(" %s in ( %s )".formatted(idFieldColumnMapper.getColumnName(), keyValues));
        }
        String deleteSql = sql.toString();
        MapperMetadata.getSqlsMap().put(tableName + "_BATCHDELETE_SQL", deleteSql);
        logger.trace("Delete SQL \n{}", (Object)deleteSql);
        return deleteSql;
    }

    public String deleteByQuery(Class<?> entityClass, Query query) {
        logger.trace("delete By Query \n{}", (Object)query);
        FieldMetadata.buildColumnList(entityClass);
        String tableName = TableMetadata.getTableName(entityClass);
        SQL sql = (SQL)((SQL)new SQL().DELETE_FROM(tableName)).WHERE(QueryBuilder.build(query));
        logger.trace("delete By Query SQL \n{}", (Object)sql);
        return sql.toString();
    }

    public String deleteByLambdaQuery(Class<?> entityClass, LambdaQuery<T> lambdaQuery) {
        logger.trace("delete By LambdaQuery \n{}", lambdaQuery);
        FieldMetadata.buildColumnList(entityClass);
        String tableName = TableMetadata.getTableName(entityClass);
        SQL sql = (SQL)((SQL)new SQL().DELETE_FROM(tableName)).WHERE(LambdaQueryBuilder.build(lambdaQuery));
        logger.trace("delete By LambdaQuery SQL \n{}", (Object)sql);
        return sql.toString();
    }
}

