/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.mybatis.jpa.id.IdentifierGeneratorFactory;
import org.apache.mybatis.jpa.persistence.FieldColumnMapper;
import org.apache.mybatis.jpa.persistence.JpaBaseDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperMetadata<T extends JpaBaseDomain> {
    private static final Logger _logger = LoggerFactory.getLogger(MapperMetadata.class);
    public static String ENTITY_CLASS = "entityClass";
    public static boolean TABLE_COLUMN_UPCASE = true;
    public static transient ConcurrentMap<String, List<FieldColumnMapper>> fieldsMap = new ConcurrentHashMap<String, List<FieldColumnMapper>>();
    public static transient ConcurrentMap<String, String> sqlsMap = new ConcurrentHashMap<String, String>();
    public static IdentifierGeneratorFactory identifierGeneratorFactory = new IdentifierGeneratorFactory();

    public static String getTableName(Class<?> entityClass) {
        Table table = entityClass.getAnnotation(Table.class);
        String tablename = "";
        tablename = table != null ? table.name() : entityClass.getClass().getSimpleName();
        return TABLE_COLUMN_UPCASE ? tablename.toUpperCase() : tablename;
    }

    public static FieldColumnMapper getIdColumn(String classSimpleName) {
        List listFields = (List)fieldsMap.get(classSimpleName);
        FieldColumnMapper idFieldColumnMapper = null;
        for (int i = 0; i < listFields.size(); ++i) {
            if (!((FieldColumnMapper)listFields.get(i)).isIdColumn()) continue;
            idFieldColumnMapper = (FieldColumnMapper)listFields.get(i);
            break;
        }
        return idFieldColumnMapper;
    }

    public static void buildColumnList(Class<?> entityClass) {
        if (fieldsMap.containsKey(entityClass.getSimpleName())) {
            return;
        }
        _logger.trace("entityClass " + entityClass);
        Field[] fields = entityClass.getDeclaredFields();
        ArrayList<FieldColumnMapper> fieldColumnMapperList = new ArrayList<FieldColumnMapper>(fields.length);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(Column.class)) continue;
            FieldColumnMapper fieldColumnMapper = new FieldColumnMapper();
            fieldColumnMapper.setFieldName(field.getName());
            fieldColumnMapper.setFieldType(field.getType().getSimpleName());
            Column columnAnnotation = field.getAnnotation(Column.class);
            if (columnAnnotation.name() != null && !columnAnnotation.name().equals("")) {
                fieldColumnMapper.setColumnName(columnAnnotation.name());
            } else if (TABLE_COLUMN_UPCASE) {
                fieldColumnMapper.setColumnName(field.getName().toUpperCase());
            } else {
                fieldColumnMapper.setColumnName(field.getName());
            }
            if (field.isAnnotationPresent(Id.class)) {
                fieldColumnMapper.setIdColumn(true);
            }
            if (field.isAnnotationPresent(GeneratedValue.class)) {
                GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
                fieldColumnMapper.setGeneratedValue(generatedValue);
            }
            _logger.trace("FieldColumnMapper : " + fieldColumnMapper);
            fieldColumnMapperList.add(fieldColumnMapper);
        }
        fieldsMap.put(entityClass.getSimpleName(), fieldColumnMapperList);
        _logger.debug("fieldsMap : " + fieldsMap);
    }

    public static class SQL_TYPE {
        public static String GET_SQL = "_GET_SQL";
        public static String FINDALL_SQL = "_FINDALL_SQL";
        public static String REMOVE_SQL = "_REMOVE_SQL";
    }
}

