/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.datasource;

import org.apache.commons.lang3.StringUtils;
import org.dromara.mybatis.jpa.datasource.DynamicDataSourceContextHolder;
import org.dromara.mybatis.jpa.datasource.DynamicRoutingDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceSwitch {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceSwitch.class);

    public static String change(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new IllegalArgumentException("DataSource key cannot be null or empty");
        }
        String currentKey = DynamicDataSourceContextHolder.getDataSource();
        logger.debug("Current DataSource: {}, Target DataSource: {}", (Object)currentKey, (Object)key);
        if (key.equals(currentKey)) {
            logger.trace("DataSource {} is already active, no change needed", (Object)key);
            return currentKey;
        }
        if (!DynamicRoutingDataSource.isExist(key)) {
            logger.error("DataSource key '{}' does not exist in the configured data sources", (Object)key);
            throw new IllegalArgumentException("DataSource key '" + key + "' does not exist");
        }
        DynamicDataSourceContextHolder.setDataSource(key);
        logger.info("Successfully switched DataSource from '{}' to '{}'", (Object)currentKey, (Object)key);
        return key;
    }

    public static String switchToDefault() {
        String defaultKey = DynamicRoutingDataSource.getDefaultDataSourceKey();
        DynamicDataSourceContextHolder.clearDataSource();
        logger.info("Switched to default DataSource: {}", (Object)defaultKey);
        return defaultKey;
    }

    public static String getCurrentDataSource() {
        return DynamicDataSourceContextHolder.getDataSource();
    }

    public static boolean exists(String key) {
        return DynamicRoutingDataSource.isExist(key);
    }
}

