/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.dialect;

import java.sql.PreparedStatement;
import java.util.HashMap;
import org.apache.mybatis.jpa.persistence.JpaPagination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Dialect {
    private static final Logger _logger = LoggerFactory.getLogger(Dialect.class);
    public static final String DEFAULT_BATCH_SIZE = "15";
    public static final String NO_BATCH = "0";
    public static final String DEFAULT_DIALECT = "mysql";
    protected static HashMap<String, String> dialectMap = new HashMap();

    static {
        dialectMap.put("db2", "org.apache.mybatis.jpa.dialect.DB2Dialect");
        dialectMap.put("derby", "org.apache.mybatis.jpa.dialect.DerbyDialect");
        dialectMap.put(DEFAULT_DIALECT, "org.apache.mybatis.jpa.dialect.MySQLDialect");
        dialectMap.put("oracle", "org.apache.mybatis.jpa.dialect.OracleDialect");
        dialectMap.put("postgresql", "org.apache.mybatis.jpa.dialect.PostgreSQLDialect");
        dialectMap.put("sqlserver", "org.apache.mybatis.jpa.dialect.SQLServerDialect");
        _logger.trace("Dialect Mapper : \n" + dialectMap);
    }

    protected Dialect() {
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getLimitString(String query, JpaPagination pagination) {
        throw new UnsupportedOperationException("Paged queries not supported by " + this.getClass().getName());
    }

    public String getPreparedStatementLimitString(String query, JpaPagination pagination) {
        throw new UnsupportedOperationException("Paged queries not supported by " + this.getClass().getName());
    }

    public void setLimitParamters(PreparedStatement preparedStatement, int parameterSize, JpaPagination pagination) {
        throw new UnsupportedOperationException("Paged queries not supported by " + this.getClass().getName());
    }

    public boolean supportsLimit() {
        return false;
    }

    public static HashMap<String, String> getDialectMap() {
        return dialectMap;
    }

    public static String getDialect(String dialect) {
        String dialectString = dialectMap.get(dialect);
        if (dialectString == null) {
            dialectString = dialectMap.get(DEFAULT_DIALECT);
        }
        return dialectString;
    }
}

