/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mybatis.jpa.persistence;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.mybatis.jpa.PageResultsSqlCache;
import org.apache.mybatis.jpa.persistence.IJpaBaseMapper;
import org.apache.mybatis.jpa.persistence.JpaBaseEntity;
import org.apache.mybatis.jpa.persistence.JpaPageResults;
import org.apache.mybatis.jpa.persistence.JpaPagination;
import org.apache.mybatis.jpa.util.BeanUtil;
import org.apache.mybatis.jpa.util.InstanceUtil;
import org.apache.mybatis.jpa.util.JpaWebContext;
import org.apache.mybatis.jpa.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaBaseService<T extends JpaBaseEntity> {
    static final Logger _logger = LoggerFactory.getLogger(JpaBaseService.class);
    @JsonIgnore
    public static final Cache<String, PageResultsSqlCache> pageResultsBoundSqlCache = Caffeine.newBuilder().expireAfterWrite(300L, TimeUnit.SECONDS).build();
    @JsonIgnore
    private String mapperClass = "";
    @JsonIgnore
    private Class entityClass;
    @JsonIgnore
    private IJpaBaseMapper<T> mapper = null;

    public JpaBaseService() {
    }

    public JpaBaseService(Class cls) {
        _logger.trace("class : {}", (Object)cls.getSimpleName());
        this.mapperClass = cls.getSimpleName();
        Type[] pType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        if (pType == null || pType.length < 1) {
            _logger.error("invalide initail, need generic type parameter! ");
            throw new RuntimeException("invalide initail, need generic type parameter!");
        }
        this.entityClass = (Class)pType[0];
        _logger.trace("class : {}", (Object)this.entityClass.getSimpleName());
    }

    public JpaBaseService(String mapperClass) {
        _logger.trace("class : {}", (Object)mapperClass);
        this.mapperClass = mapperClass;
    }

    public void setMapper(IJpaBaseMapper<T> mapper) {
        this.mapper = mapper;
    }

    public IJpaBaseMapper<T> getMapper() {
        try {
            if (this.mapper == null) {
                String mapperClassBean = String.valueOf(this.mapperClass.toLowerCase().charAt(0)) + this.mapperClass.substring(1);
                _logger.info("mapperClass Bean is {}", (Object)mapperClassBean);
                this.mapper = (IJpaBaseMapper)JpaWebContext.getBean(mapperClassBean);
            }
        }
        catch (Exception e) {
            _logger.error("getMapper Exception ", (Throwable)e);
        }
        return this.mapper;
    }

    public JpaPageResults<T> queryPageResults(T entity) {
        ((JpaPagination)entity).setPageResultSelectUUID(((JpaBaseEntity)entity).generateId());
        ((JpaPagination)entity).setStartRow(this.calculateStartRow(((JpaPagination)entity).getPageNumber(), ((JpaPagination)entity).getPageSize()));
        ((JpaPagination)entity).setPageable(true);
        List<T> resultslist = this.getMapper().queryPageResults(entity);
        ((JpaPagination)entity).setPageable(false);
        Integer totalPage = resultslist.size();
        Integer totalCount = 0;
        totalCount = ((JpaPagination)entity).getPageNumber() == 1 && totalPage < ((JpaPagination)entity).getPageSize() ? totalPage : this.parseCount(this.getMapper().queryPageResultsCount(entity));
        return new JpaPageResults<T>(((JpaPagination)entity).getPageNumber(), ((JpaPagination)entity).getPageSize(), (int)totalPage, totalCount, resultslist);
    }

    public JpaPageResults<T> queryPageResults(String mapperId, T entity) {
        ((JpaPagination)entity).setPageResultSelectUUID(((JpaBaseEntity)entity).generateId());
        ((JpaPagination)entity).setStartRow(this.calculateStartRow(((JpaPagination)entity).getPageNumber(), ((JpaPagination)entity).getPageSize()));
        ((JpaPagination)entity).setPageable(true);
        List resultslist = null;
        try {
            resultslist = (List)InstanceUtil.invokeMethod(this.getMapper(), mapperId, new Object[]{entity});
        }
        catch (Exception e) {
            _logger.error("queryPageResults Exception ", (Throwable)e);
        }
        ((JpaPagination)entity).setPageable(false);
        Integer totalPage = resultslist.size();
        Integer totalCount = 0;
        totalCount = ((JpaPagination)entity).getPageNumber() == 1 && totalPage < ((JpaPagination)entity).getPageSize() ? totalPage : this.parseCount(this.getMapper().queryPageResultsCount(entity));
        return new JpaPageResults(((JpaPagination)entity).getPageNumber(), ((JpaPagination)entity).getPageSize(), (int)totalPage, totalCount, resultslist);
    }

    public Integer queryPageResultsCount(T entity) {
        Integer count = 0;
        try {
            if (entity == null) {
                entity = (JpaBaseEntity)this.entityClass.newInstance();
            }
            count = this.getMapper().queryPageResultsCount(entity);
            _logger.debug("queryCount count : {}", (Object)count);
        }
        catch (Exception e) {
            _logger.error("queryPageResultsCount Exception ", (Throwable)e);
        }
        return count;
    }

    public List<T> query(T entity) {
        try {
            if (entity == null) {
                entity = (JpaBaseEntity)this.entityClass.newInstance();
            }
            return this.getMapper().query(entity);
        }
        catch (Exception e) {
            _logger.error("query Exception ", (Throwable)e);
            return null;
        }
    }

    public List<T> findAll() {
        try {
            return this.getMapper().findAll(this.entityClass);
        }
        catch (Exception e) {
            _logger.error("findAll Exception ", (Throwable)e);
            return null;
        }
    }

    public List<T> find(String filter, Object[] args, int[] argTypes) {
        try {
            return this.getMapper().find(this.entityClass, filter, args, argTypes);
        }
        catch (Exception e) {
            _logger.error("findAll Exception ", (Throwable)e);
            return null;
        }
    }

    public List<T> find(String filter) {
        return this.find(filter, null, null);
    }

    public T findOne(String filter, Object[] args, int[] argTypes) {
        try {
            List<T> findList = this.find(filter, args, argTypes);
            return (T)(findList == null || findList.size() == 0 ? null : (JpaBaseEntity)findList.get(0));
        }
        catch (Exception e) {
            _logger.error("findAll Exception ", (Throwable)e);
            return null;
        }
    }

    public T findOne(String filter) {
        return this.findOne(filter, null, null);
    }

    public T load(T entity) {
        try {
            List<T> entityList = this.getMapper().query(entity);
            return (T)(entityList != null && entityList.size() > 0 ? (JpaBaseEntity)entityList.get(0) : null);
        }
        catch (Exception e) {
            _logger.error("load Exception ", (Throwable)e);
            return null;
        }
    }

    public T get(String id) {
        try {
            _logger.debug("entityClass  {} , primaryKey {}", (Object)this.entityClass.toGenericString(), (Object)id);
            return (T)((JpaBaseEntity)this.getMapper().get(this.entityClass, id));
        }
        catch (Exception e) {
            _logger.error("get Exception ", (Throwable)e);
            return null;
        }
    }

    public boolean insert(T entity) {
        try {
            Integer count = this.getMapper().insert(entity);
            _logger.debug("insert count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            _logger.error("insert Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean insertBatch(List<T> listEntity) {
        try {
            if (BeanUtil.isNotNull(listEntity)) {
                Integer count = 0;
                for (JpaBaseEntity entity : listEntity) {
                    if (this.getMapper().insert(entity) <= 0) continue;
                    count = count + 1;
                }
                _logger.debug("Insert Batch count : {}", (Object)count);
                return count > 0;
            }
        }
        catch (Exception e) {
            _logger.error("Insert Batch Exception ", (Throwable)e);
        }
        return false;
    }

    public boolean persist(T entity) {
        return this.insert(entity);
    }

    public boolean merge(T entity) {
        T loadedEntity = this.load(entity);
        if (loadedEntity == null) {
            return this.insert(entity);
        }
        return this.update(entity);
    }

    public boolean update(T entity) {
        try {
            Integer count = this.getMapper().update(entity);
            _logger.debug("update count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            _logger.error("update Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean delete(T entity) {
        try {
            Integer count = this.getMapper().delete(entity);
            _logger.debug("delete count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            _logger.error("delete Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean deleteBatch(List<String> idList) {
        try {
            _logger.trace("deleteBatch {}", idList);
            Integer count = this.getMapper().deleteBatch(this.entityClass, idList);
            _logger.debug("deleteBatch count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            _logger.error("deleteBatch Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean deleteBatch(String ids) {
        List<String> idList = StringUtils.string2List(ids, ",");
        return this.deleteBatch(idList);
    }

    public boolean deleteBatch(String ids, String split) {
        List<String> idList = StringUtils.string2List(ids, split);
        return this.deleteBatch(idList);
    }

    public boolean remove(String id) {
        try {
            Integer count = this.getMapper().remove(this.entityClass, id);
            _logger.debug("remove count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            _logger.error("remove Exception ", (Throwable)e);
            return false;
        }
    }

    public boolean logicDelete(List<String> idList) {
        try {
            _logger.trace("logicDelete {}", idList);
            Integer count = this.getMapper().logicDelete(this.entityClass, idList);
            _logger.debug("logicDelete count : {}", (Object)count);
            return count > 0;
        }
        catch (Exception e) {
            _logger.error("logicDelete Exception ", (Throwable)e);
            return true;
        }
    }

    public boolean logicDelete(String ids) {
        List<String> idList = StringUtils.string2List(ids, ",");
        return this.logicDelete(idList);
    }

    public boolean logicDelete(String ids, String split) {
        List<String> idList = StringUtils.string2List(ids, split);
        return this.logicDelete(idList);
    }

    public Integer parseCount(Object totalCount) {
        Integer retTotalCount = 0;
        if (totalCount == null) {
            return retTotalCount;
        }
        retTotalCount = Integer.parseInt(totalCount.toString());
        return retTotalCount;
    }

    public Integer calculateTotalPage(JpaBaseEntity entity, Integer totalCount) {
        return (totalCount + entity.getPageSize() - 1) / entity.getPageSize();
    }

    public Integer calculateStartRow(Integer page, Integer pageSize) {
        return (page - 1) * pageSize;
    }
}

