/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.user;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.user.UserDestinationResolver;
import org.springframework.messaging.simp.user.UserSessionRegistry;
import org.springframework.util.Assert;

public class DefaultUserDestinationResolver
implements UserDestinationResolver {
    private static final Log logger = LogFactory.getLog(DefaultUserDestinationResolver.class);
    private final UserSessionRegistry userSessionRegistry;
    private String destinationPrefix = "/user/";
    private String subscriptionDestinationPrefix = "/user/queue/";

    public DefaultUserDestinationResolver(UserSessionRegistry userSessionRegistry) {
        Assert.notNull((Object)userSessionRegistry, (String)"'userSessionRegistry' must not be null");
        this.userSessionRegistry = userSessionRegistry;
    }

    public void setUserDestinationPrefix(String prefix) {
        Assert.hasText((String)prefix, (String)"prefix must not be empty");
        this.destinationPrefix = prefix.endsWith("/") ? prefix : prefix + "/";
        this.subscriptionDestinationPrefix = this.destinationPrefix + "queue/";
    }

    public String getDestinationPrefix() {
        return this.destinationPrefix;
    }

    public String getSubscriptionDestinationPrefix() {
        return this.subscriptionDestinationPrefix;
    }

    public UserSessionRegistry getUserSessionRegistry() {
        return this.userSessionRegistry;
    }

    @Override
    public Set<String> resolveDestination(Message<?> message) {
        SimpMessageHeaderAccessor headers = SimpMessageHeaderAccessor.wrap(message);
        UserDestinationInfo info = this.getUserDestinationInfo(headers);
        if (info == null) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (String sessionId : this.userSessionRegistry.getSessionIds(info.getUser())) {
            set.add(this.getTargetDestination(headers.getDestination(), info.getDestination(), sessionId, info.getUser()));
        }
        return set;
    }

    protected String getTargetDestination(String originalDestination, String targetDestination, String sessionId, String user) {
        return targetDestination + "-user" + sessionId;
    }

    private UserDestinationInfo getUserDestinationInfo(SimpMessageHeaderAccessor headers) {
        String targetDestination;
        String targetUser;
        String destination = headers.getDestination();
        Principal user = headers.getUser();
        SimpMessageType messageType = headers.getMessageType();
        if (SimpMessageType.SUBSCRIBE.equals((Object)messageType) || SimpMessageType.UNSUBSCRIBE.equals((Object)messageType)) {
            if (!this.checkDestination(destination, this.subscriptionDestinationPrefix)) {
                return null;
            }
            if (user == null) {
                logger.warn((Object)"Ignoring message, no user information");
                return null;
            }
            targetUser = user.getName();
            targetDestination = destination.substring(this.destinationPrefix.length() - 1);
        } else if (SimpMessageType.MESSAGE.equals((Object)messageType)) {
            if (!this.checkDestination(destination, this.destinationPrefix)) {
                return null;
            }
            int startIndex = this.destinationPrefix.length();
            int endIndex = destination.indexOf(47, startIndex);
            Assert.isTrue((endIndex > 0 ? 1 : 0) != 0, (String)"Expected destination pattern \"/user/{userId}/**\"");
            targetUser = destination.substring(startIndex, endIndex);
            targetDestination = destination.substring(endIndex);
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring " + (Object)((Object)messageType) + " message"));
            }
            return null;
        }
        return new UserDestinationInfo(targetUser, targetDestination);
    }

    protected boolean checkDestination(String destination, String requiredPrefix) {
        if (destination == null) {
            logger.trace((Object)"Ignoring message, no destination");
            return false;
        }
        if (!destination.startsWith(requiredPrefix)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Ignoring message to " + destination + ", not a \"user\" destination"));
            }
            return false;
        }
        return true;
    }

    private static class UserDestinationInfo {
        private final String user;
        private final String destination;

        private UserDestinationInfo(String user, String destination) {
            this.user = user;
            this.destination = destination;
        }

        private String getUser() {
            return this.user;
        }

        private String getDestination() {
            return this.destination;
        }
    }
}

