/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication.preauth.websphere;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.authentication.preauth.websphere.DefaultWASUsernameAndGroupsExtractor;
import org.springframework.security.web.authentication.preauth.websphere.WASUsernameAndGroupsExtractor;
import org.springframework.security.web.authentication.preauth.websphere.WebSpherePreAuthenticatedAuthenticationDetailsSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class WebSphere2SpringSecurityPropagationInterceptor
implements MethodInterceptor {
    private static final Log logger = LogFactory.getLog(WebSphere2SpringSecurityPropagationInterceptor.class);
    private AuthenticationManager authenticationManager = null;
    private AuthenticationDetailsSource<?, ?> authenticationDetailsSource = new WebSpherePreAuthenticatedAuthenticationDetailsSource();
    private final WASUsernameAndGroupsExtractor wasHelper;

    public WebSphere2SpringSecurityPropagationInterceptor() {
        this(new DefaultWASUsernameAndGroupsExtractor());
    }

    WebSphere2SpringSecurityPropagationInterceptor(WASUsernameAndGroupsExtractor wasHelper) {
        this.wasHelper = wasHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        try {
            logger.debug((Object)"Performing Spring Security authentication with WebSphere credentials");
            this.authenticateSpringSecurityWithWASCredentials();
            logger.debug((Object)"Proceeding with method invocation");
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            logger.debug((Object)"Clearing Spring Security security context");
            SecurityContextHolder.clearContext();
        }
    }

    private void authenticateSpringSecurityWithWASCredentials() {
        Assert.notNull((Object)this.authenticationManager);
        Assert.notNull(this.authenticationDetailsSource);
        String userName = this.wasHelper.getCurrentUserName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating authentication request for user " + userName));
        }
        PreAuthenticatedAuthenticationToken authRequest = new PreAuthenticatedAuthenticationToken(userName, "N/A");
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails(null));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication request for user " + userName + ": " + (Object)((Object)authRequest)));
        }
        Authentication authResponse = this.authenticationManager.authenticate((Authentication)authRequest);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authentication response for user " + userName + ": " + authResponse));
        }
        SecurityContextHolder.getContext().setAuthentication(authResponse);
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<?, ?> authenticationDetailsSource) {
        this.authenticationDetailsSource = authenticationDetailsSource;
    }
}

