/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.util;

import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;
import org.dromara.mybatis.jpa.crypto.utils.Base64Utils;

public class StringGenerator {
    private static final char[] DEFAULT_CODEC = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] DEFAULT_CODE_NUMBER = "1234567890".toCharArray();
    public static final char[] DEFAULT_CODE_LOWERCASE = "abcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] DEFAULT_CODE_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    public static final char[] DEFAULT_CODE_LETTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    public static final char[] DEFAULT_CODE_NUMBER_LETTERS = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final String UUID_REGEX = "^[0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12}$";
    private Random random = new SecureRandom();
    private int length;
    private char[] codec = DEFAULT_CODEC;

    public StringGenerator() {
        this(6);
    }

    public StringGenerator(int length) {
        this.length = length;
    }

    public StringGenerator(char[] defaultCode, int length) {
        this.codec = defaultCode;
        this.length = length;
    }

    public String randomGenerate() {
        byte[] verifierBytes = new byte[this.length];
        this.random.nextBytes(verifierBytes);
        return this.getString(verifierBytes);
    }

    public String uuidGenerate() {
        return UUID.randomUUID().toString().toLowerCase();
    }

    public String uniqueGenerate() {
        StringBuilder uniqueString = new StringBuilder("");
        this.length = 9;
        String randomString = this.randomGenerate();
        uniqueString.append(randomString.subSequence(0, 4));
        Date currentDate = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyyHHmmssSSS");
        String dateString = Base64Utils.encodeBase64(dateFormat.format(currentDate).getBytes());
        dateString = dateString.substring(0, dateString.length() - 1);
        uniqueString.append(dateString);
        uniqueString.append(randomString.subSequence(5, 8));
        return uniqueString.toString();
    }

    protected String getString(byte[] verifierBytes) {
        char[] chars = new char[verifierBytes.length];
        for (int i = 0; i < verifierBytes.length; ++i) {
            chars[i] = this.codec[(verifierBytes[i] & 0xFF) % this.codec.length];
        }
        return new String(chars);
    }

    public void setRandom(Random random) {
        this.random = random;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setCodec(char[] codec) {
        this.codec = codec;
    }

    public static boolean uuidMatches(String uuidString) {
        return uuidString.matches(UUID_REGEX);
    }
}

