/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.metadata.findby;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindByMapper {
    private static final Logger logger = LoggerFactory.getLogger(FindByMapper.class);
    String mappedStatementId;
    String mappedStatementMethodName;
    String removedFindByName;
    Class<?> mappedStatementClass;
    String mappedStatementClassName;
    Class<?> entityClass;
    boolean isDistinct = false;

    public FindByMapper(String mappedStatementId) {
        this.mappedStatementId = mappedStatementId;
    }

    public void parseFindBy() {
        this.mappedStatementClassName = this.mappedStatementId.substring(0, this.mappedStatementId.lastIndexOf("."));
        logger.trace("mappedStatementClass {}", (Object)this.mappedStatementClassName);
        this.mappedStatementMethodName = this.mappedStatementId.substring(this.mappedStatementId.lastIndexOf(".") + 1);
        logger.trace("methodName {}", (Object)this.mappedStatementMethodName);
        if (this.mappedStatementMethodName.startsWith("findBy")) {
            this.removedFindByName = this.mappedStatementMethodName.substring("findBy".length());
        } else if (this.mappedStatementMethodName.startsWith("findDistinctBy")) {
            this.isDistinct = true;
            this.removedFindByName = this.mappedStatementMethodName.substring("findDistinctBy".length());
        }
        logger.trace("removed FindBy name : {}", (Object)this.removedFindByName);
    }

    public void parseEntityClass() {
        try {
            ParameterizedType parameterizedType;
            this.mappedStatementClass = Class.forName(this.mappedStatementClassName);
            Type[] pType = this.mappedStatementClass.getGenericInterfaces();
            if (pType != null && pType.length >= 1 && (parameterizedType = (ParameterizedType)pType[0]) != null && parameterizedType.getActualTypeArguments().length > 0) {
                this.entityClass = (Class)parameterizedType.getActualTypeArguments()[0];
                logger.trace("Entity Class : {}", (Object)this.entityClass.getCanonicalName());
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getMappedStatementId() {
        return this.mappedStatementId;
    }

    public String getMappedStatementMethodName() {
        return this.mappedStatementMethodName;
    }

    public String getRemovedFindByName() {
        return this.removedFindByName;
    }

    public Class<?> getMappedStatementClass() {
        return this.mappedStatementClass;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }
}

