/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.crypto.impl;

import java.sql.SQLException;
import org.dromara.mybatis.jpa.crypto.SymmetricEncrypt;
import org.dromara.mybatis.jpa.crypto.utils.ReciprocalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesEncrypt
implements SymmetricEncrypt {
    private static final Logger logger = LoggerFactory.getLogger(DesEncrypt.class);
    static DesEncrypt encrypt;
    static final String PREFIX = "{desec}";
    static final String PLAIN = "{plain}";
    String salt = "3e4a1d42";
    static final int PREFFIX_LENGTH = 7;

    public DesEncrypt() {
    }

    public DesEncrypt(String cryptKey) {
        this.salt = ReciprocalUtils.cutSecretKey(cryptKey, "DES");
    }

    public static DesEncrypt getInstance() {
        if (encrypt == null) {
            encrypt = new DesEncrypt();
        }
        return encrypt;
    }

    @Override
    public String decrypt(String ciphers) throws SQLException {
        if (ciphers == null) {
            return null;
        }
        String encodedPasswordString = ciphers;
        if (encodedPasswordString.startsWith(PREFIX)) {
            try {
                return ReciprocalUtils.decoderHex(encodedPasswordString.substring(7), this.salt, "DES");
            }
            catch (Exception e) {
                logger.error("decryptHex_DES Exception", (Throwable)e);
            }
        } else if (encodedPasswordString.startsWith(PLAIN)) {
            return encodedPasswordString.substring(7);
        }
        return encodedPasswordString;
    }

    @Override
    public String encrypt(String simple) throws SQLException {
        return this.encodeToHex(simple);
    }

    public String encode(CharSequence plain, boolean isEncode) {
        if (isEncode) {
            return this.encodeToHex(plain);
        }
        return PLAIN + String.valueOf(plain);
    }

    private String encodeToHex(CharSequence plain) {
        if (plain == null) {
            return null;
        }
        try {
            return PREFIX + ReciprocalUtils.encode2Hex(plain.toString(), this.salt, "DES");
        }
        catch (Exception e) {
            logger.error("encryptHex_DES Exception", (Throwable)e);
            return "";
        }
    }

    public String getSalt() {
        return this.salt;
    }

    @Override
    public void setSalt(String salt) {
        this.salt = salt;
    }
}

