/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.toplink.embedded.websocket.impl;

import com.taobao.api.internal.toplink.embedded.websocket.WebSocket;
import com.taobao.api.internal.toplink.embedded.websocket.exception.ErrorCode;
import com.taobao.api.internal.toplink.embedded.websocket.exception.WebSocketException;
import com.taobao.api.internal.toplink.embedded.websocket.frame.Frame;
import com.taobao.api.internal.toplink.embedded.websocket.frame.FrameHeader;
import com.taobao.api.internal.toplink.embedded.websocket.frame.FrameParser;
import com.taobao.api.internal.toplink.embedded.websocket.frame.draft76.BinaryFrame;
import com.taobao.api.internal.toplink.embedded.websocket.frame.draft76.CloseFrame;
import com.taobao.api.internal.toplink.embedded.websocket.frame.draft76.FrameBuilderDraft76;
import com.taobao.api.internal.toplink.embedded.websocket.frame.draft76.TextFrame;
import com.taobao.api.internal.toplink.embedded.websocket.handler.StreamHandlerAdapter;
import com.taobao.api.internal.toplink.embedded.websocket.handler.StreamHandlerChain;
import com.taobao.api.internal.toplink.embedded.websocket.handler.WebSocketHandler;
import com.taobao.api.internal.toplink.embedded.websocket.handler.WebSocketPipeline;
import com.taobao.api.internal.toplink.embedded.websocket.handshake.Handshake;
import com.taobao.api.internal.toplink.embedded.websocket.impl.WebSocketBase;
import com.taobao.api.internal.toplink.embedded.websocket.proxy.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.Random;

public class WebSocketDraft76
extends WebSocketBase {
    private static final int VERSION = 76;

    public WebSocketDraft76(String url, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        super(url, (String)null, handler, protocols);
    }

    public WebSocketDraft76(String url, Proxy proxy, WebSocketHandler handler, String ... protocols) throws WebSocketException {
        super(url, (String)null, proxy, handler, protocols);
    }

    protected Handshake newHandshakeInstance() {
        return new Handshake(){
            private ByteBuffer bodyBuf = ByteBuffer.allocate(16);

            public ByteBuffer createHandshakeRequest() {
                this.bodyBuf.clear();
                StringBuilder sb = new StringBuilder();
                sb.append("GET " + WebSocketDraft76.this.path + " HTTP/1.1\r\n");
                WebSocketBase.addHeader(sb, "Host", WebSocketDraft76.this.endpointAddress.getHostName());
                WebSocketBase.addHeader(sb, "Upgrade", "websocket");
                WebSocketBase.addHeader(sb, "Connection", "Upgrade");
                WebSocketBase.addHeader(sb, "Sec-WebSocket-Key1", SecWebSocketKey.generateKey());
                WebSocketBase.addHeader(sb, "Sec-WebSocket-Key2", SecWebSocketKey.generateKey());
                if (WebSocketDraft76.this.origin != null) {
                    WebSocketBase.addHeader(sb, "Origin", WebSocketDraft76.this.origin);
                }
                if (WebSocketDraft76.this.protocols != null && WebSocketDraft76.this.protocols.length > 0) {
                    WebSocketBase.addHeader(sb, "Sec-WebSocket-Protocol", WebSocketBase.join(",", WebSocketDraft76.this.protocols));
                }
                sb.append("\r\n");
                ByteBuffer buf = ByteBuffer.allocate(512);
                buf.put(sb.toString().getBytes());
                buf.put(SecWebSocketKey.generateKey3());
                buf.put((byte)13);
                buf.put((byte)10);
                buf.flip();
                return buf;
            }

            protected boolean parseHandshakeResponseHeader(ByteBuffer buffer) throws WebSocketException {
                if (!super.parseHandshakeResponseHeader(buffer)) {
                    return false;
                }
                if (!"websocket".equalsIgnoreCase(this.getResponseHeader().getHeaderValue("upgrade"))) {
                    throw new WebSocketException(ErrorCode.E3500, WebSocketDraft76.this.responseHeader.getHeaderValue("upgrade"));
                }
                if (!"upgrade".equalsIgnoreCase(this.getResponseHeader().getHeaderValue("connection"))) {
                    throw new WebSocketException(ErrorCode.E3501, WebSocketDraft76.this.responseHeader.getHeaderValue("connection"));
                }
                String serverOrigin = this.getResponseHeader().getHeaderValue("sec-websocket-origin");
                if (WebSocketDraft76.this.origin != null && serverOrigin != null && !serverOrigin.equals(WebSocketDraft76.this.origin)) {
                    throw new WebSocketException(ErrorCode.E3502, WebSocketDraft76.this.origin, serverOrigin);
                }
                String serverLocation = this.getResponseHeader().getHeaderValue("sec-websocket-location");
                try {
                    URI uri = new URI(WebSocketDraft76.this.location.getScheme(), WebSocketDraft76.this.location.getHost(), WebSocketDraft76.this.location.getPath(), WebSocketDraft76.this.location.getFragment());
                    if (serverLocation != null && !serverLocation.equals(uri.toString())) {
                        throw new WebSocketException(ErrorCode.E3503, uri.toString(), serverLocation);
                    }
                }
                catch (URISyntaxException uri) {
                    // empty catch block
                }
                String protocolStr = this.getResponseHeader().getHeaderValue("sec-websocket-protocol");
                if (protocolStr != null) {
                    WebSocketDraft76.this.serverProtocols = protocolStr.split(",");
                }
                return true;
            }

            protected boolean parseHandshakeResponseBody(ByteBuffer buffer) throws WebSocketException {
                if (!super.parseHandshakeResponseBody(buffer)) {
                    return false;
                }
                if (buffer.remaining() < this.bodyBuf.capacity()) {
                    return false;
                }
                buffer.get(this.bodyBuf.array(), 0, this.bodyBuf.capacity());
                return true;
            }
        };
    }

    protected int getWebSocketVersion() {
        return 76;
    }

    public Frame createFrame(byte[] bytes) throws WebSocketException {
        return new BinaryFrame(bytes);
    }

    public Frame createFrame(String str) throws WebSocketException {
        return new TextFrame(str);
    }

    protected FrameParser newFrameParserInstance() {
        return new FrameParser(){

            protected FrameHeader createFrameHeader(ByteBuffer chunkData) {
                return FrameBuilderDraft76.createFrameHeader(chunkData);
            }

            protected Frame createFrame(FrameHeader h, byte[] bodyData) {
                return FrameBuilderDraft76.createFrame(h, bodyData);
            }
        };
    }

    protected void initializePipeline(WebSocketPipeline pipeline) throws WebSocketException {
        super.initializePipeline(pipeline);
        this.pipeline.addStreamHandler(new StreamHandlerAdapter(){

            public void nextDownstreamHandler(WebSocket ws, ByteBuffer buffer, Frame frame, StreamHandlerChain chain) throws WebSocketException {
                if (frame instanceof CloseFrame) {
                    WebSocketDraft76.this.handler.onClose(ws);
                } else {
                    WebSocketDraft76.this.handler.onMessage(ws, frame);
                }
            }

            public void nextHandshakeDownstreamHandler(WebSocket ws, ByteBuffer buffer, StreamHandlerChain chain) throws WebSocketException {
                WebSocketDraft76.this.responseHeader = WebSocketDraft76.this.getHandshake().getResponseHeader();
                WebSocketDraft76.this.responseStatus = WebSocketDraft76.this.getHandshake().getResponseStatus();
                WebSocketDraft76.this.transitionTo(WebSocketBase.State.WAIT);
                WebSocketDraft76.this.handler.onOpen(WebSocketDraft76.this);
            }
        });
    }

    private static class SecWebSocketKey {
        private static final Random random;
        private static final long LARGEST_INTEGER = 0xFFFFFFFFL;
        private static final char[] CHARS;

        private SecWebSocketKey() {
        }

        public static String generateKey() {
            int position;
            int i;
            int spaces = random.nextInt(12) + 1;
            long max = 0xFFFFFFFFL / (long)spaces;
            long number = Math.abs(random.nextLong()) % max;
            long product = number * (long)spaces;
            StringBuilder key = new StringBuilder();
            key.append(product);
            int charsNum = random.nextInt(12) + 1;
            for (i = 0; i < charsNum; ++i) {
                position = random.nextInt(key.length());
                char c = CHARS[random.nextInt(CHARS.length)];
                key.insert(position, c);
            }
            for (i = 0; i < spaces; ++i) {
                position = random.nextInt(key.length() - 1) + 1;
                key.insert(position, ' ');
            }
            return key.toString();
        }

        public static byte[] generateKey3() {
            byte[] key3 = new byte[8];
            random.nextBytes(key3);
            return key3;
        }

        static {
            int c;
            random = new Random();
            CHARS = new char[84];
            int i = 0;
            for (c = 33; c <= 47; ++c) {
                SecWebSocketKey.CHARS[i++] = (char)c;
            }
            for (c = 58; c <= 126; ++c) {
                SecWebSocketKey.CHARS[i++] = (char)c;
            }
        }
    }
}

