/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mybatis.jpa.spring;

import java.util.Collections;
import java.util.List;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.dromara.mybatis.jpa.crypto.EncryptFactory;
import org.dromara.mybatis.jpa.dialect.DialectMapper;
import org.dromara.mybatis.jpa.interceptor.FieldAutoFillInterceptor;
import org.dromara.mybatis.jpa.interceptor.FieldDecryptInterceptor;
import org.dromara.mybatis.jpa.interceptor.FieldEncryptInterceptor;
import org.dromara.mybatis.jpa.interceptor.StatementHandlerInterceptor;
import org.dromara.mybatis.jpa.interceptor.TraceSqlIntercept;
import org.dromara.mybatis.jpa.metadata.MapperMetadata;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisJpaSessionFactoryBean
extends SqlSessionFactoryBean {
    protected static Logger logger = LoggerFactory.getLogger(MyBatisJpaSessionFactoryBean.class);
    private int timeout = 30;
    private String dialect = "mysql";
    private String cryptKey = "l0JqT7NvIzP9oRaG4kFc1QmD_bWu3x8E5yS2h6";
    private List<Interceptor> interceptors = Collections.emptyList();

    public void setInterceptors(List<Interceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setCryptKey(String cryptKey) {
        this.cryptKey = cryptKey;
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws Exception {
        SqlSessionFactory factory = super.buildSqlSessionFactory();
        Configuration config = factory.getConfiguration();
        logger.debug("buildSqlSessionFactory : {}", (Object)config);
        for (Interceptor interceptor : this.interceptors) {
            config.addInterceptor(interceptor);
        }
        MapperMetadata.setEncryptFactory(new EncryptFactory(this.cryptKey));
        StatementHandlerInterceptor statementHandlerInterceptor = new StatementHandlerInterceptor();
        statementHandlerInterceptor.setDialectString(DialectMapper.getDialect(this.dialect));
        config.addInterceptor((Interceptor)statementHandlerInterceptor);
        config.addInterceptor((Interceptor)new FieldEncryptInterceptor());
        config.addInterceptor((Interceptor)new FieldDecryptInterceptor());
        config.addInterceptor((Interceptor)new FieldAutoFillInterceptor());
        config.addInterceptor((Interceptor)new TraceSqlIntercept());
        if (config.getDefaultStatementTimeout() == null || config.getDefaultStatementTimeout() == 0) {
            config.setDefaultStatementTimeout(Integer.valueOf(this.timeout));
        }
        logger.debug("DefaultStatementTimeout : {}", (Object)config.getDefaultStatementTimeout());
        if (logger.isTraceEnabled()) {
            for (String mappedStatementName : config.getMappedStatementNames()) {
                logger.trace("MappedStatementName {} ", (Object)mappedStatementName);
            }
        }
        return factory;
    }

    public SqlSessionFactory build() throws Exception {
        return this.buildSqlSessionFactory();
    }
}

