/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint.adapter;

import com.connsec.config.oidc.OIDCProviderMetadata;
import com.connsec.crypto.ReciprocalUtils;
import com.connsec.crypto.jwt.signer.service.JwtSigningAndValidationService;
import com.connsec.crypto.jwt.signer.service.impl.SymmetricSigningAndValidationServiceBuilder;
import com.connsec.domain.UserInfo;
import com.connsec.domain.apps.Applications;
import com.connsec.domain.apps.TokenBasedDetails;
import com.connsec.web.WebContext;
import com.connsec.web.authorize.endpoint.adapter.AbstractAuthorizeAdapter;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import org.joda.time.DateTime;
import org.springframework.web.servlet.ModelAndView;

public class TokenBasedJWTHS256Adapter
extends AbstractAuthorizeAdapter {
    private SymmetricSigningAndValidationServiceBuilder symmetricJwtSignerServiceBuilder = new SymmetricSigningAndValidationServiceBuilder();

    public String generateInfo(UserInfo userInfo, Object app) {
        TokenBasedDetails details = (TokenBasedDetails)app;
        OIDCProviderMetadata providerMetadata = (OIDCProviderMetadata)WebContext.getBean((String)"oidcProviderMetadata");
        DateTime currentDateTime = DateTime.now();
        JWTClaimsSet jwtClaims = new JWTClaimsSet();
        jwtClaims.setIssuer(providerMetadata.getIssuer());
        jwtClaims.setSubject(userInfo.getUsername());
        jwtClaims.setAudience(Arrays.asList(details.getId()));
        Date expirationTime = currentDateTime.plusMinutes(Integer.parseInt(details.getExpires())).toDate();
        _logger.debug("expiration Time : " + expirationTime);
        jwtClaims.setExpirationTime(expirationTime);
        jwtClaims.setJWTID(UUID.randomUUID().toString());
        jwtClaims.setIssueTime(currentDateTime.toDate());
        jwtClaims.setCustomClaim("email", (Object)userInfo.getWorkEmail());
        jwtClaims.setCustomClaim("name", (Object)userInfo.getUsername());
        jwtClaims.setCustomClaim("user_id", (Object)userInfo.getId());
        jwtClaims.setJWTID(userInfo.getWorkEmail());
        jwtClaims.setCustomClaim("external_id", (Object)userInfo.getId());
        jwtClaims.setCustomClaim("locale", (Object)userInfo.getLocale());
        _logger.debug("jwt Claims : " + jwtClaims);
        PlainJWT jwtToken = new PlainJWT(jwtClaims);
        String sharedSecret = ReciprocalUtils.decoder((String)details.getAlgorithmKey());
        _logger.debug("jwt sharedSecret : " + sharedSecret);
        JwtSigningAndValidationService symmetricJwtSignerService = this.symmetricJwtSignerServiceBuilder.serviceBuilder(sharedSecret);
        if (symmetricJwtSignerService != null) {
            jwtClaims.setCustomClaim("kid", (Object)"SYMMETRIC-KEY");
            jwtToken = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), jwtClaims);
            symmetricJwtSignerService.signJwt((SignedJWT)jwtToken);
        }
        String tokenString = jwtToken.serialize();
        _logger.debug("jwt Token : " + tokenString);
        return tokenString;
    }

    public String encrypt(String data, String algorithmKey, String algorithm) {
        return data;
    }

    public String sign(String data, Applications app) {
        return data;
    }

    public ModelAndView authorize(UserInfo userInfo, Object app, String data, ModelAndView modelAndView) {
        modelAndView.setViewName("authorize/tokenbased_jwt_sso_submint");
        TokenBasedDetails details = (TokenBasedDetails)app;
        modelAndView.addObject("action", (Object)details.getRedirectUri());
        _logger.debug("jwt Token data : " + data);
        modelAndView.addObject("token", (Object)data);
        return modelAndView;
    }
}

