/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint;

import com.connsec.config.ApplicationConfig;
import com.connsec.constants.BOOLEAN;
import com.connsec.dao.service.TokenBasedDetailsService;
import com.connsec.domain.apps.Applications;
import com.connsec.domain.apps.TokenBasedDetails;
import com.connsec.util.Instance;
import com.connsec.web.WebContext;
import com.connsec.web.authorize.endpoint.AuthorizeBaseEndpoint;
import com.connsec.web.authorize.endpoint.adapter.AbstractAuthorizeAdapter;
import com.connsec.web.authorize.endpoint.adapter.TokenBasedDefaultAdapter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class TokenBasedAuthorizeEndpoint
extends AuthorizeBaseEndpoint {
    static final Logger _logger = LoggerFactory.getLogger(TokenBasedAuthorizeEndpoint.class);
    @Autowired
    TokenBasedDetailsService tokenBasedDetailsService;
    TokenBasedDefaultAdapter defaultTokenBasedAdapter = new TokenBasedDefaultAdapter();
    @Autowired
    ApplicationConfig applicationConfig;

    @RequestMapping(value={"/authorize/tokenbased/{id}"})
    public ModelAndView authorize(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="id") String id) {
        ModelAndView modelAndView = new ModelAndView();
        TokenBasedDetails tokenBasedDetails = null;
        if (id.equals("manage")) {
            tokenBasedDetails = new TokenBasedDetails();
            tokenBasedDetails.setId("manage");
            tokenBasedDetails.setName("Manage App");
            tokenBasedDetails.setProtocol("Token_Based");
            tokenBasedDetails.setIsAdapter(1);
            tokenBasedDetails.setAdapter("com.connsec.web.authorize.endpoint.adapter.TokenBasedJWTAdapter");
            tokenBasedDetails.setRedirectUri(this.applicationConfig.getManageUri());
            tokenBasedDetails.setExpires("2");
        } else {
            tokenBasedDetails = (TokenBasedDetails)this.tokenBasedDetailsService.get(id);
        }
        _logger.debug("" + tokenBasedDetails);
        TokenBasedDefaultAdapter adapter = BOOLEAN.isTrue((int)tokenBasedDetails.getIsAdapter()) ? (AbstractAuthorizeAdapter)Instance.newInstance((String)tokenBasedDetails.getAdapter()) : this.defaultTokenBasedAdapter;
        String tokenData = adapter.generateInfo(WebContext.getUserInfo(), tokenBasedDetails);
        String encryptTokenData = adapter.encrypt(tokenData, tokenBasedDetails.getAlgorithmKey(), tokenBasedDetails.getAlgorithm());
        String signTokenData = adapter.sign(encryptTokenData, (Applications)tokenBasedDetails);
        modelAndView = adapter.authorize(WebContext.getUserInfo(), tokenBasedDetails, signTokenData, modelAndView);
        return modelAndView;
    }
}

