/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider.token.store;

import com.connsec.redis.RedisConnection;
import com.connsec.redis.RedisConnectionFactory;
import com.connsec.util.ObjectTransformer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.security.oauth2.common.ExpiringOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.DefaultAuthenticationKeyGenerator;
import org.springframework.security.oauth2.provider.token.TokenStore;

public class RedisTokenStore
implements TokenStore {
    private static final String ACCESS = "REDIS_OAUTH_V20_access:";
    private static final String AUTH_TO_ACCESS = "REDIS_OAUTH_V20_auth_to_access:";
    private static final String AUTH = "REDIS_OAUTH_V20_auth:";
    private static final String REFRESH_AUTH = "REDIS_OAUTH_V20_refresh_auth:";
    private static final String ACCESS_TO_REFRESH = "REDIS_OAUTH_V20_access_to_refresh:";
    private static final String REFRESH = "REDIS_OAUTH_V20_refresh:";
    private static final String REFRESH_TO_ACCESS = "REDIS_OAUTH_V20_refresh_to_access:";
    private static final String CLIENT_ID_TO_ACCESS = "REDIS_OAUTH_V20_client_id_to_access:";
    private static final String UNAME_TO_ACCESS = "REDIS_OAUTH_V20_uname_to_access:";
    private final RedisConnectionFactory connectionFactory;
    private AuthenticationKeyGenerator authenticationKeyGenerator = new DefaultAuthenticationKeyGenerator();
    private String prefix = "";

    public RedisTokenStore(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setAuthenticationKeyGenerator(AuthenticationKeyGenerator authenticationKeyGenerator) {
        this.authenticationKeyGenerator = authenticationKeyGenerator;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private RedisConnection getConnection() {
        return this.connectionFactory.getConnection();
    }

    @Override
    public OAuth2AccessToken getAccessToken(OAuth2Authentication authentication) {
        String key = this.authenticationKeyGenerator.extractKey(authentication);
        String serializedKey = AUTH_TO_ACCESS + key;
        RedisConnection conn = this.getConnection();
        OAuth2AccessToken accessToken = (OAuth2AccessToken)conn.getObject(serializedKey);
        if (accessToken != null && !key.equals(this.authenticationKeyGenerator.extractKey(this.readAuthentication(accessToken.getValue())))) {
            this.storeAccessToken(accessToken, authentication);
        }
        return accessToken;
    }

    @Override
    public OAuth2Authentication readAuthentication(OAuth2AccessToken token) {
        return this.readAuthentication(token.getValue());
    }

    @Override
    public OAuth2Authentication readAuthentication(String token) {
        RedisConnection conn = this.getConnection();
        OAuth2Authentication auth = (OAuth2Authentication)((Object)conn.getObject(AUTH + token));
        return auth;
    }

    @Override
    public OAuth2Authentication readAuthenticationForRefreshToken(OAuth2RefreshToken token) {
        return this.readAuthenticationForRefreshToken(token.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth2Authentication readAuthenticationForRefreshToken(String token) {
        try (RedisConnection conn = this.getConnection();){
            OAuth2Authentication auth;
            OAuth2Authentication oAuth2Authentication = auth = (OAuth2Authentication)((Object)conn.getObject(REFRESH_AUTH + token));
            return oAuth2Authentication;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeAccessToken(OAuth2AccessToken token, OAuth2Authentication authentication) {
        String accessKey = ACCESS + token.getValue();
        String authKey = AUTH + token.getValue();
        String authToAccessKey = AUTH_TO_ACCESS + this.authenticationKeyGenerator.extractKey(authentication);
        String approvalKey = UNAME_TO_ACCESS + RedisTokenStore.getApprovalKey(authentication);
        String clientId = CLIENT_ID_TO_ACCESS + authentication.getOAuth2Request().getClientId();
        try (RedisConnection conn = this.getConnection();){
            OAuth2RefreshToken refreshToken;
            conn.openPipeline();
            conn.setObject(accessKey, (Serializable)token);
            conn.setObject(authKey, (Serializable)((Object)authentication));
            conn.setObject(authToAccessKey, (Serializable)token);
            if (!authentication.isClientOnly()) {
                conn.rPush(approvalKey, (Serializable)token);
            }
            conn.rPush(clientId, (Serializable)token);
            if (token.getExpiration() != null) {
                int seconds = token.getExpiresIn();
                conn.expire(accessKey, seconds);
                conn.expire(authKey, seconds);
                conn.expire(authToAccessKey, seconds);
                conn.expire(clientId, seconds);
                conn.expire(approvalKey, seconds);
            }
            if ((refreshToken = token.getRefreshToken()) != null && refreshToken.getValue() != null) {
                ExpiringOAuth2RefreshToken expiringRefreshToken;
                Date expiration;
                String refresh = token.getRefreshToken().getValue();
                String auth = token.getValue();
                String refreshToAccessKey = REFRESH_TO_ACCESS + token.getRefreshToken().getValue();
                conn.set(refreshToAccessKey, auth);
                String accessToRefreshKey = ACCESS_TO_REFRESH + token.getValue();
                conn.set(accessToRefreshKey, refresh);
                if (refreshToken instanceof ExpiringOAuth2RefreshToken && (expiration = (expiringRefreshToken = (ExpiringOAuth2RefreshToken)refreshToken).getExpiration()) != null) {
                    int seconds = Long.valueOf((expiration.getTime() - System.currentTimeMillis()) / 1000L).intValue();
                    conn.expire(refreshToAccessKey, seconds);
                    conn.expire(accessToRefreshKey, seconds);
                }
            }
            conn.closePipeline();
        }
    }

    private static String getApprovalKey(OAuth2Authentication authentication) {
        String userName = authentication.getUserAuthentication() == null ? "" : authentication.getUserAuthentication().getName();
        return RedisTokenStore.getApprovalKey(authentication.getOAuth2Request().getClientId(), userName);
    }

    private static String getApprovalKey(String clientId, String userName) {
        return clientId + (userName == null ? "" : ":" + userName);
    }

    @Override
    public void removeAccessToken(OAuth2AccessToken accessToken) {
        this.removeAccessToken(accessToken.getValue());
    }

    @Override
    public OAuth2AccessToken readAccessToken(String tokenValue) {
        RedisConnection conn = this.getConnection();
        String key = ACCESS + tokenValue;
        OAuth2AccessToken accessToken = (OAuth2AccessToken)conn.getObject(key);
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAccessToken(String tokenValue) {
        String accessKey = ACCESS + tokenValue;
        String authKey = AUTH + tokenValue;
        String accessToRefreshKey = ACCESS_TO_REFRESH + tokenValue;
        try (RedisConnection conn = this.getConnection();){
            conn.openPipeline();
            conn.delete(accessKey);
            conn.delete(accessToRefreshKey);
            conn.delete(authKey);
            List results = conn.closePipeline();
            String access = (String)results.get(0);
            String auth = (String)results.get(1);
            OAuth2Authentication authentication = (OAuth2Authentication)((Object)ObjectTransformer.deserialize((String)auth));
            if (authentication != null) {
                String key = this.authenticationKeyGenerator.extractKey(authentication);
                String authToAccessKey = AUTH_TO_ACCESS + key;
                String unameKey = UNAME_TO_ACCESS + RedisTokenStore.getApprovalKey(authentication);
                String clientId = CLIENT_ID_TO_ACCESS + authentication.getOAuth2Request().getClientId();
                conn.openPipeline();
                conn.delete(authToAccessKey);
                conn.lRem(unameKey, 1, access);
                conn.lRem(clientId, 1, access);
                conn.delete(ACCESS + key);
                conn.closePipeline();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeRefreshToken(OAuth2RefreshToken refreshToken, OAuth2Authentication authentication) {
        String refreshKey = REFRESH + refreshToken.getValue();
        String refreshAuthKey = REFRESH_AUTH + refreshToken.getValue();
        try (RedisConnection conn = this.getConnection();){
            ExpiringOAuth2RefreshToken expiringRefreshToken;
            Date expiration;
            conn.openPipeline();
            conn.setObject(refreshKey, (Serializable)refreshToken);
            conn.setObject(refreshAuthKey, (Serializable)((Object)authentication));
            if (refreshToken instanceof ExpiringOAuth2RefreshToken && (expiration = (expiringRefreshToken = (ExpiringOAuth2RefreshToken)refreshToken).getExpiration()) != null) {
                int seconds = Long.valueOf((expiration.getTime() - System.currentTimeMillis()) / 1000L).intValue();
                conn.expire(refreshKey, seconds);
                conn.expire(refreshAuthKey, seconds);
            }
            conn.closePipeline();
        }
    }

    @Override
    public OAuth2RefreshToken readRefreshToken(String tokenValue) {
        String key = REFRESH + tokenValue;
        RedisConnection conn = this.getConnection();
        OAuth2RefreshToken refreshToken = (OAuth2RefreshToken)conn.getObject(key);
        conn.close();
        return refreshToken;
    }

    @Override
    public void removeRefreshToken(OAuth2RefreshToken refreshToken) {
        this.removeRefreshToken(refreshToken.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefreshToken(String tokenValue) {
        String refreshKey = REFRESH + tokenValue;
        String refreshAuthKey = REFRESH_AUTH + tokenValue;
        String refresh2AccessKey = REFRESH_TO_ACCESS + tokenValue;
        String access2RefreshKey = ACCESS_TO_REFRESH + tokenValue;
        try (RedisConnection conn = this.getConnection();){
            conn.openPipeline();
            conn.delete(refreshKey);
            conn.delete(refreshAuthKey);
            conn.delete(refresh2AccessKey);
            conn.delete(access2RefreshKey);
            conn.closePipeline();
        }
    }

    @Override
    public void removeAccessTokenUsingRefreshToken(OAuth2RefreshToken refreshToken) {
        this.removeAccessTokenUsingRefreshToken(refreshToken.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAccessTokenUsingRefreshToken(String refreshToken) {
        String key = REFRESH_TO_ACCESS + refreshToken;
        List results = null;
        try (RedisConnection conn = this.getConnection();){
            conn.openPipeline();
            conn.get(key);
            conn.delete(key);
            results = conn.closePipeline();
        }
        if (results == null) {
            return;
        }
        String bytes = (String)results.get(0);
        String accessToken = (String)ObjectTransformer.deserialize((String)bytes);
        if (accessToken != null) {
            this.removeAccessToken(accessToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OAuth2AccessToken> findTokensByClientIdAndUserName(String clientId, String userName) {
        String approvalKey = UNAME_TO_ACCESS + RedisTokenStore.getApprovalKey(clientId, userName);
        List stringList = null;
        try (RedisConnection conn = this.getConnection();){
            stringList = conn.lRange(approvalKey, 0, -1);
        }
        if (stringList == null || stringList.size() == 0) {
            return Collections.emptySet();
        }
        ArrayList<OAuth2AccessToken> accessTokens = new ArrayList<OAuth2AccessToken>(stringList.size());
        for (String str : stringList) {
            OAuth2AccessToken accessToken = (OAuth2AccessToken)conn.getObject(str);
            accessTokens.add(accessToken);
        }
        return Collections.unmodifiableCollection(accessTokens);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OAuth2AccessToken> findTokensByClientId(String clientId) {
        String key = CLIENT_ID_TO_ACCESS + clientId;
        List stringList = null;
        try (RedisConnection conn = this.getConnection();){
            stringList = conn.lRange(key, 0, -1);
        }
        if (stringList == null || stringList.size() == 0) {
            return Collections.emptySet();
        }
        ArrayList<OAuth2AccessToken> accessTokens = new ArrayList<OAuth2AccessToken>(stringList.size());
        for (String str : stringList) {
            OAuth2AccessToken accessToken = (OAuth2AccessToken)conn.getObject(str);
            accessTokens.add(accessToken);
        }
        return Collections.unmodifiableCollection(accessTokens);
    }
}

