/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.config.annotation.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.security.config.annotation.SecurityBuilder;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.config.annotation.builders.InMemoryClientDetailsServiceBuilder;
import org.springframework.security.oauth2.config.annotation.builders.JdbcClientDetailsServiceBuilder;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;

public class ClientDetailsServiceBuilder<B extends ClientDetailsServiceBuilder<B>>
extends SecurityConfigurerAdapter<ClientDetailsService, B>
implements SecurityBuilder<ClientDetailsService> {
    private List<ClientBuilder> clientBuilders = new ArrayList<ClientBuilder>();

    public InMemoryClientDetailsServiceBuilder inMemory() throws Exception {
        return new InMemoryClientDetailsServiceBuilder();
    }

    public JdbcClientDetailsServiceBuilder jdbc() throws Exception {
        return new JdbcClientDetailsServiceBuilder();
    }

    public ClientDetailsServiceBuilder<?> clients(final ClientDetailsService clientDetailsService) throws Exception {
        return new ClientDetailsServiceBuilder(){

            @Override
            public ClientDetailsService build() throws Exception {
                return clientDetailsService;
            }
        };
    }

    public ClientBuilder withClient(String clientId) {
        ClientBuilder clientBuilder = new ClientBuilder(clientId);
        this.clientBuilders.add(clientBuilder);
        return clientBuilder;
    }

    public ClientDetailsService build() throws Exception {
        for (ClientBuilder clientDetailsBldr : this.clientBuilders) {
            this.addClient(clientDetailsBldr.clientId, clientDetailsBldr.build());
        }
        return this.performBuild();
    }

    protected void addClient(String clientId, ClientDetails build) {
    }

    protected ClientDetailsService performBuild() {
        throw new UnsupportedOperationException("Cannot build client services (maybe use inMemory() or jdbc()).");
    }

    public final class ClientBuilder {
        private final String clientId;
        private Collection<String> authorizedGrantTypes = new LinkedHashSet<String>();
        private Collection<String> authorities = new LinkedHashSet<String>();
        private Integer accessTokenValiditySeconds;
        private Integer refreshTokenValiditySeconds;
        private Collection<String> scopes = new LinkedHashSet<String>();
        private Collection<String> autoApproveScopes = new HashSet<String>();
        private String secret;
        private Set<String> registeredRedirectUris = new HashSet<String>();
        private Set<String> resourceIds = new HashSet<String>();
        private boolean autoApprove;
        private Map<String, Object> additionalInformation = new LinkedHashMap<String, Object>();

        private ClientDetails build() {
            BaseClientDetails result = new BaseClientDetails();
            result.setClientId(this.clientId);
            result.setAuthorizedGrantTypes(this.authorizedGrantTypes);
            result.setAccessTokenValiditySeconds(this.accessTokenValiditySeconds);
            result.setRefreshTokenValiditySeconds(this.refreshTokenValiditySeconds);
            result.setRegisteredRedirectUri(this.registeredRedirectUris);
            result.setClientSecret(this.secret);
            result.setScope(this.scopes);
            result.setAuthorities((Collection)AuthorityUtils.createAuthorityList((String[])this.authorities.toArray(new String[this.authorities.size()])));
            result.setResourceIds(this.resourceIds);
            result.setAdditionalInformation(this.additionalInformation);
            if (this.autoApprove) {
                result.setAutoApproveScopes(this.scopes);
            } else {
                result.setAutoApproveScopes(this.autoApproveScopes);
            }
            return result;
        }

        public ClientBuilder resourceIds(String ... resourceIds) {
            for (String resourceId : resourceIds) {
                this.resourceIds.add(resourceId);
            }
            return this;
        }

        public ClientBuilder redirectUris(String ... registeredRedirectUris) {
            for (String redirectUri : registeredRedirectUris) {
                this.registeredRedirectUris.add(redirectUri);
            }
            return this;
        }

        public ClientBuilder authorizedGrantTypes(String ... authorizedGrantTypes) {
            for (String grant : authorizedGrantTypes) {
                this.authorizedGrantTypes.add(grant);
            }
            return this;
        }

        public ClientBuilder accessTokenValiditySeconds(int accessTokenValiditySeconds) {
            this.accessTokenValiditySeconds = accessTokenValiditySeconds;
            return this;
        }

        public ClientBuilder refreshTokenValiditySeconds(int refreshTokenValiditySeconds) {
            this.refreshTokenValiditySeconds = refreshTokenValiditySeconds;
            return this;
        }

        public ClientBuilder secret(String secret) {
            this.secret = secret;
            return this;
        }

        public ClientBuilder scopes(String ... scopes) {
            for (String scope : scopes) {
                this.scopes.add(scope);
            }
            return this;
        }

        public ClientBuilder authorities(String ... authorities) {
            for (String authority : authorities) {
                this.authorities.add(authority);
            }
            return this;
        }

        public ClientBuilder autoApprove(boolean autoApprove) {
            this.autoApprove = autoApprove;
            return this;
        }

        public ClientBuilder autoApprove(String ... scopes) {
            for (String scope : scopes) {
                this.autoApproveScopes.add(scope);
            }
            return this;
        }

        public ClientBuilder additionalInformation(Map<String, ?> map) {
            this.additionalInformation.putAll(map);
            return this;
        }

        public ClientBuilder additionalInformation(String ... pairs) {
            for (String pair : pairs) {
                int index;
                String separator = ":";
                if (!pair.contains(separator) && pair.contains("=")) {
                    separator = "=";
                }
                String key = pair.substring(0, (index = pair.indexOf(separator)) > 0 ? index : pair.length());
                String value = index > 0 ? pair.substring(index + 1) : null;
                this.additionalInformation.put(key, value);
            }
            return this;
        }

        public ClientDetailsServiceBuilder<B> and() {
            return ClientDetailsServiceBuilder.this;
        }

        private ClientBuilder(String clientId) {
            this.clientId = clientId;
        }
    }
}

