/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.oidc.idtoken;

import com.connsec.config.oidc.OIDCProviderMetadata;
import com.connsec.crypto.ReciprocalUtils;
import com.connsec.crypto.jwt.encryption.service.JwtEncryptionAndDecryptionService;
import com.connsec.crypto.jwt.encryption.service.impl.RecipientJwtEncryptionAndDecryptionServiceBuilder;
import com.connsec.crypto.jwt.signer.service.JwtSigningAndValidationService;
import com.connsec.crypto.jwt.signer.service.impl.SymmetricSigningAndValidationServiceBuilder;
import com.connsec.oidc.idtoken.IdTokenHashUtils;
import com.connsec.web.WebContext;
import com.google.common.base.Strings;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;

public class OIDCIdTokenEnhancer
implements TokenEnhancer {
    private static final Logger logger = LoggerFactory.getLogger(OIDCIdTokenEnhancer.class);
    public static final String ID_TOKEN_SCOPE = "openid";
    private OIDCProviderMetadata providerMetadata;
    private JwtSigningAndValidationService jwtSignerService;
    private JwtEncryptionAndDecryptionService jwtEnDecryptionService;
    private ClientDetailsService clientDetailsService;
    private SymmetricSigningAndValidationServiceBuilder symmetricJwtSignerServiceBuilder = new SymmetricSigningAndValidationServiceBuilder();
    private RecipientJwtEncryptionAndDecryptionServiceBuilder recipientJwtEnDecryptionServiceBuilder = new RecipientJwtEncryptionAndDecryptionServiceBuilder();

    public void setProviderMetadata(OIDCProviderMetadata providerMetadata) {
        this.providerMetadata = providerMetadata;
    }

    public void setJwtSignerService(JwtSigningAndValidationService jwtSignerService) {
        this.jwtSignerService = jwtSignerService;
    }

    public void setJwtEnDecryptionService(JwtEncryptionAndDecryptionService jwtEnDecryptionService) {
        this.jwtEnDecryptionService = jwtEnDecryptionService;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }

    @Override
    public OAuth2AccessToken enhance(OAuth2AccessToken accessToken, OAuth2Authentication authentication) {
        OAuth2Request request = authentication.getOAuth2Request();
        if (request.getScope().contains(ID_TOKEN_SCOPE)) {
            String nonce;
            ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(authentication.getOAuth2Request().getClientId());
            JWTClaimsSet idClaims = new JWTClaimsSet.Builder().subject(authentication.getName()).expirationTime(accessToken.getExpiration()).claim(this.providerMetadata.getIssuer(), (Object)true).issueTime(new Date()).audience(Arrays.asList(authentication.getOAuth2Request().getClientId())).jwtID(UUID.randomUUID().toString()).build();
            if (this.providerMetadata.getIssuer().equalsIgnoreCase("https://self-issued.me")) {
                idClaims.setCustomClaim("sub_jwk", this.jwtSignerService.getAllPublicKeys().get(this.jwtSignerService.getDefaultSignerKeyId()));
            }
            if (request.getExtensions().containsKey("max_age") || request.getExtensions().containsKey("idtoken")) {
                DateTime loginDate = DateTime.parse((String)WebContext.getUserInfo().getLastLoginTime(), (DateTimeFormatter)DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss"));
                idClaims.setClaim("auth_time", (Object)(loginDate.getMillis() / 1000L));
            }
            if (!Strings.isNullOrEmpty((String)(nonce = (String)((Object)request.getExtensions().get("nonce"))))) {
                idClaims.setCustomClaim("nonce", (Object)nonce);
            }
            JWSAlgorithm signingAlg = this.jwtSignerService.getDefaultSigningAlgorithm();
            SignedJWT signed = new SignedJWT(new JWSHeader(signingAlg), idClaims);
            Set<String> responseTypes = request.getResponseTypes();
            if (responseTypes.contains("token")) {
                Base64URL at_hash = IdTokenHashUtils.getAccessTokenHash(signingAlg, (JWT)signed);
                idClaims.setClaim("at_hash", (Object)at_hash);
            }
            logger.debug("idClaims " + idClaims);
            PlainJWT idToken = null;
            if (clientDetails.getIdTokenEncryptedAlgorithm() != null && !clientDetails.getIdTokenEncryptedAlgorithm().equals("none") && clientDetails.getIdTokenEncryptionMethod() != null && !clientDetails.getIdTokenEncryptionMethod().equals("none") && clientDetails.getJwksUri() != null && clientDetails.getJwksUri().length() > 4) {
                JwtEncryptionAndDecryptionService recipientJwtEnDecryptionService = this.recipientJwtEnDecryptionServiceBuilder.serviceBuilder(clientDetails.getJwksUri());
                if (recipientJwtEnDecryptionService != null) {
                    JWEAlgorithm jweAlgorithm = new JWEAlgorithm(clientDetails.getIdTokenEncryptedAlgorithm());
                    EncryptionMethod encryptionMethod = new EncryptionMethod(clientDetails.getIdTokenEncryptionMethod());
                    EncryptedJWT encryptedJWT = new EncryptedJWT(new JWEHeader(jweAlgorithm, encryptionMethod), idClaims);
                    recipientJwtEnDecryptionService.encryptJwt((JWEObject)encryptedJWT);
                    idToken = encryptedJWT;
                } else {
                    logger.error("Couldn't create Jwt Encryption Service");
                }
            } else if (signingAlg == null || signingAlg.equals((Object)"none")) {
                idToken = new PlainJWT(idClaims);
            } else if (signingAlg.equals((Object)JWSAlgorithm.HS256) || signingAlg.equals((Object)JWSAlgorithm.HS384) || signingAlg.equals((Object)JWSAlgorithm.HS512)) {
                String client_secret = ReciprocalUtils.decoder((String)clientDetails.getClientSecret());
                JwtSigningAndValidationService symmetricJwtSignerService = this.symmetricJwtSignerServiceBuilder.serviceBuilder(client_secret);
                if (symmetricJwtSignerService != null) {
                    idClaims.setCustomClaim("kid", (Object)"SYMMETRIC-KEY");
                    idToken = new SignedJWT(new JWSHeader(signingAlg), idClaims);
                    symmetricJwtSignerService.signJwt((SignedJWT)idToken);
                } else {
                    logger.error("Couldn't create symmetric validator for client " + clientDetails.getClientId() + " without a client secret");
                }
            } else {
                idClaims.setCustomClaim("kid", (Object)this.jwtSignerService.getDefaultSignerKeyId());
                idToken = new SignedJWT(new JWSHeader(signingAlg), idClaims);
                this.jwtSignerService.signJwt((SignedJWT)idToken);
            }
            logger.debug("idToken " + idToken);
            accessToken = new DefaultOAuth2AccessToken(accessToken);
            if (idToken != null) {
                accessToken.getAdditionalInformation().put("id_token", idToken.serialize());
            }
        }
        return accessToken;
    }
}

