/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint;

import com.connsec.config.ApplicationConfig;
import com.connsec.constants.BOOLEAN;
import com.connsec.dao.service.TokenBasedDetailsService;
import com.connsec.domain.apps.Applications;
import com.connsec.domain.apps.TokenBasedDetails;
import com.connsec.util.Instance;
import com.connsec.web.WebContext;
import com.connsec.web.authorize.endpoint.AuthorizeBaseEndpoint;
import com.connsec.web.authorize.endpoint.adapter.AbstractAuthorizeAdapter;
import com.connsec.web.authorize.endpoint.adapter.LtpaDefaultAdapter;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LtpaAuthorizeEndpoint
extends AuthorizeBaseEndpoint {
    static final Logger _logger = LoggerFactory.getLogger(LtpaAuthorizeEndpoint.class);
    @Autowired
    TokenBasedDetailsService tokenBasedDetailsService;
    @Autowired
    ApplicationConfig applicationConfig;
    LtpaDefaultAdapter defaultLtpaAdapter = new LtpaDefaultAdapter();

    @RequestMapping(value={"/authz/ltpa/{id}"})
    public ModelAndView authorize(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="id") String id) {
        String signTokenData;
        TokenBasedDetails ltpaDetails = (TokenBasedDetails)this.tokenBasedDetailsService.get(id);
        _logger.debug("" + ltpaDetails);
        String cookieValue = "";
        LtpaDefaultAdapter adapter = BOOLEAN.isTrue((int)ltpaDetails.getIsAdapter()) ? (AbstractAuthorizeAdapter)Instance.newInstance((String)ltpaDetails.getAdapter()) : this.defaultLtpaAdapter;
        String tokenData = adapter.generateInfo(WebContext.getUserInfo(), ltpaDetails);
        String encryptTokenData = adapter.encrypt(tokenData, ltpaDetails.getAlgorithmKey(), ltpaDetails.getAlgorithm());
        cookieValue = signTokenData = adapter.sign(encryptTokenData, (Applications)ltpaDetails);
        _logger.debug("Cookie Name : " + ltpaDetails.getCookieName());
        Cookie cookie = new Cookie(ltpaDetails.getCookieName(), cookieValue);
        Integer maxAge = Integer.parseInt(ltpaDetails.getExpires()) * 60;
        _logger.debug("Cookie Max Age :" + maxAge + " seconds.");
        cookie.setMaxAge(maxAge.intValue());
        cookie.setPath("/");
        cookie.setDomain("." + this.applicationConfig.getSubDomainName());
        _logger.debug("Sub Domain Name : ." + this.applicationConfig.getSubDomainName());
        response.addCookie(cookie);
        if (ltpaDetails.getRedirectUri().indexOf(this.applicationConfig.getSubDomainName()) > -1) {
            return WebContext.redirect((String)ltpaDetails.getRedirectUri());
        }
        _logger.error(ltpaDetails.getRedirectUri() + " not in domain " + this.applicationConfig.getSubDomainName());
        return null;
    }
}

