/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint.response;

import com.connsec.web.authorize.endpoint.response.CasServiceResponse;
import java.util.ArrayList;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceResponseBuilder
extends CasServiceResponse {
    static final Logger _logger = LoggerFactory.getLogger(ServiceResponseBuilder.class);

    @Override
    public String serviceResponseBuilder() {
        String responseString = "";
        responseString = this.format.equalsIgnoreCase("xml") ? this.serviceResponseXmlBuilder() : this.serviceResponseJsonBuilder();
        _logger.debug("Response String : " + responseString);
        return responseString;
    }

    public String serviceResponseXmlBuilder() {
        StringBuffer responseResult = new StringBuffer("");
        responseResult.append("<cas:serviceResponse xmlns:cas=\"http://www.yale.edu/tp/cas\">");
        if (this.result) {
            responseResult.append("<cas:authenticationSuccess>");
            responseResult.append("<cas:user>").append(this.user).append("</cas:user>");
            if (this.ticket != null) {
                responseResult.append("<cas:proxyGrantingTicket>").append(this.ticket).append("</cas:proxyGrantingTicket>");
            }
            if (!this.casAttributes.isEmpty()) {
                responseResult.append("<cas:attributes>");
                for (String key : this.casAttributes.keySet()) {
                    ArrayList attrList = (ArrayList)this.casAttributes.get(key);
                    for (String value : attrList) {
                        responseResult.append("<cas:").append(key).append(">");
                        responseResult.append(value);
                        responseResult.append("</cas:").append(key).append(">\r\n");
                    }
                }
                responseResult.append("</cas:attributes>");
            }
            if (!this.proxies.isEmpty()) {
                responseResult.append("<cas:proxies>");
                for (String proxy : this.proxies) {
                    responseResult.append("<cas:proxy>").append(proxy).append("</cas:proxy>");
                }
                responseResult.append("</cas:proxies>");
            }
            responseResult.append("</cas:authenticationSuccess>");
        } else {
            responseResult.append("<cas:authenticationFailure code=\"" + this.code + "\">");
            responseResult.append(this.description);
            responseResult.append("</cas:authenticationFailure>");
        }
        responseResult.append("</cas:serviceResponse>");
        return responseResult.toString();
    }

    public String serviceResponseJsonBuilder() {
        StringBuffer responseResult = new StringBuffer("");
        responseResult.append("{\"serviceResponse\" :{");
        if (this.result) {
            responseResult.append("\"authenticationSuccess\" : {");
            responseResult.append("\"user\" : \"").append(this.user).append("\"");
            if (this.ticket != null) {
                responseResult.append(",\"proxyGrantingTicket\" : \"").append(this.ticket).append("\"");
            }
            if (!this.casAttributes.isEmpty()) {
                responseResult.append(",\"attributes\" : {");
                Iterator it = this.casAttributes.keySet().iterator();
                int attrCount = 1;
                while (it.hasNext()) {
                    String key = (String)it.next();
                    ArrayList attrList = (ArrayList)this.casAttributes.get(key);
                    if (attrCount == 1) {
                        responseResult.append("\"").append(key).append("\":");
                    } else {
                        responseResult.append(",\"").append(key).append("\":");
                    }
                    String valueString = "";
                    if (attrList.size() == 1) {
                        valueString = "\"" + (String)attrList.get(0) + "\"";
                    } else {
                        int valueCount = 1;
                        valueString = valueString + "[";
                        for (String value : attrList) {
                            if (valueCount != 1) {
                                valueString = valueString + ",";
                            }
                            valueString = valueString + "\"" + value + "\"";
                            ++valueCount;
                        }
                        valueString = valueString + "]";
                    }
                    responseResult.append(valueString);
                    ++attrCount;
                }
                responseResult.append("}");
            }
            if (!this.proxies.isEmpty()) {
                responseResult.append(",\"proxies\" : [ ");
                int proxyCount = 1;
                for (String proxy : this.proxies) {
                    if (proxyCount != 1) {
                        responseResult.append(",");
                    }
                    responseResult.append("\"").append(proxy).append("\"");
                    ++proxyCount;
                }
                responseResult.append("]");
            }
            responseResult.append("}");
        } else {
            responseResult.append("\"authenticationFailure\" : {");
            responseResult.append("\"code\" : \"").append(this.code).append("\"");
            responseResult.append(",\"description\" : \"").append(this.description).append("\"");
            responseResult.append("}");
        }
        responseResult.append("}");
        responseResult.append("}");
        return responseResult.toString();
    }
}

