/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint.cas.ticket.service;

import com.connsec.redis.RedisConnection;
import com.connsec.redis.RedisConnectionFactory;
import com.connsec.web.authorize.endpoint.cas.ticket.Ticket;
import com.connsec.web.authorize.endpoint.cas.ticket.service.RandomServiceTicketServices;
import java.io.Serializable;

public class RedisTicketServices
extends RandomServiceTicketServices {
    protected int serviceTicketValiditySeconds = 600;
    RedisConnectionFactory connectionFactory;
    public static String PREFIX = "REDIS_CAS_SERVICE_TICKET_";

    public RedisTicketServices(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public RedisTicketServices() {
    }

    public void setConnectionFactory(RedisConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    protected void store(String ticketId, Ticket ticket) {
        RedisConnection conn = this.connectionFactory.getConnection();
        conn.setexObject(PREFIX + ticketId, this.serviceTicketValiditySeconds, (Serializable)ticket);
        conn.close();
    }

    @Override
    public Ticket remove(String ticketId) {
        RedisConnection conn = this.connectionFactory.getConnection();
        Ticket ticket = (Ticket)conn.getObject(PREFIX + ticketId);
        conn.delete(PREFIX + ticketId);
        conn.close();
        return ticket;
    }
}

