/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint.cas.ticket.service;

import com.connsec.web.authorize.endpoint.cas.ticket.Ticket;
import com.connsec.web.authorize.endpoint.cas.ticket.generator.DefaultUniqueTicketIdGenerator;
import com.connsec.web.authorize.endpoint.cas.ticket.service.TicketServices;
import org.springframework.security.oauth2.common.exceptions.InvalidGrantException;

public abstract class RandomServiceTicketServices
implements TicketServices {
    private DefaultUniqueTicketIdGenerator generator = new DefaultUniqueTicketIdGenerator();

    protected abstract void store(String var1, Ticket var2);

    protected abstract Ticket remove(String var1);

    @Override
    public String createTicket(Ticket ticket) {
        String ticketId = "";
        if (ticket.getClass().getSimpleName().equalsIgnoreCase("ServiceTicketImpl")) {
            ticketId = this.generator.getNewTicketId("ST");
        } else if (ticket.getClass().getSimpleName().equalsIgnoreCase("ProxyTicketImpl")) {
            ticketId = this.generator.getNewTicketId("PT");
        } else if (ticket.getClass().getSimpleName().equalsIgnoreCase("ProxyTicketImpl")) {
            ticketId = this.generator.getNewTicketId("PT");
        } else if (ticket.getClass().getSimpleName().equalsIgnoreCase("ProxyTicketImpl")) {
            ticketId = this.generator.getNewTicketId("PT");
        }
        this.store(ticketId, ticket);
        return ticketId;
    }

    @Override
    public Ticket consumeTicket(String ticketId) throws InvalidGrantException {
        Ticket ticket = this.remove(ticketId);
        if (ticket == null) {
            throw new InvalidGrantException("Invalid authorization code: " + ticketId);
        }
        return ticket;
    }
}

