/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint.cas.ticket.service;

import com.connsec.web.authorize.endpoint.cas.ticket.Ticket;
import com.connsec.web.authorize.endpoint.cas.ticket.service.RandomServiceTicketServices;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.SqlLobValue;
import org.springframework.security.oauth2.common.util.SerializationUtils;
import org.springframework.util.Assert;

public class JdbcTicketServices
extends RandomServiceTicketServices {
    private static final String DEFAULT_SELECT_STATEMENT = "select id, ticket from cas_ticket where id = ?";
    private static final String DEFAULT_INSERT_STATEMENT = "insert into cas_ticket (id, ticket) values (?, ?)";
    private static final String DEFAULT_DELETE_STATEMENT = "delete from cas_ticket where id = ?";
    private String selectAuthenticationSql = "select id, ticket from cas_ticket where id = ?";
    private String insertAuthenticationSql = "insert into cas_ticket (id, ticket) values (?, ?)";
    private String deleteAuthenticationSql = "delete from cas_ticket where id = ?";
    private final JdbcTemplate jdbcTemplate;

    public JdbcTicketServices(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"DataSource required");
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    protected void store(String ticketId, Ticket ticket) {
        this.jdbcTemplate.update(this.insertAuthenticationSql, new Object[]{ticket, new SqlLobValue(SerializationUtils.serialize((Object)ticket))}, new int[]{12, 2004});
    }

    @Override
    public Ticket remove(String ticketId) {
        Ticket ticket;
        try {
            ticket = (Ticket)this.jdbcTemplate.queryForObject(this.selectAuthenticationSql, (RowMapper)new RowMapper<Ticket>(){

                public Ticket mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return (Ticket)SerializationUtils.deserialize((byte[])rs.getBytes("ticket"));
                }
            }, new Object[]{ticketId});
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
        if (ticket != null) {
            this.jdbcTemplate.update(this.deleteAuthenticationSql, new Object[]{ticket});
        }
        return ticket;
    }

    public void setSelectAuthenticationSql(String selectAuthenticationSql) {
        this.selectAuthenticationSql = selectAuthenticationSql;
    }

    public void setInsertAuthenticationSql(String insertAuthenticationSql) {
        this.insertAuthenticationSql = insertAuthenticationSql;
    }

    public void setDeleteAuthenticationSql(String deleteAuthenticationSql) {
        this.deleteAuthenticationSql = deleteAuthenticationSql;
    }
}

