/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint.cas.ticket.generator;

import com.connsec.web.authorize.endpoint.cas.ticket.generator.DefaultUniqueTicketIdGenerator;
import com.connsec.web.authorize.endpoint.cas.ticket.generator.InetAddressUtils;
import org.apache.commons.lang3.StringUtils;

public class HostNameBasedUniqueTicketIdGenerator
extends DefaultUniqueTicketIdGenerator {
    public HostNameBasedUniqueTicketIdGenerator(int maxLength, String suffix) {
        super(maxLength, HostNameBasedUniqueTicketIdGenerator.determineTicketSuffixByHostName(suffix));
    }

    private static String determineTicketSuffixByHostName(String suffix) {
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            return suffix;
        }
        return InetAddressUtils.getCasServerHostName();
    }

    public static class ProxyTicketIdGenerator
    extends HostNameBasedUniqueTicketIdGenerator {
        public ProxyTicketIdGenerator(int maxLength, String suffix) {
            super(maxLength, suffix);
        }
    }

    public static class ServiceTicketIdGenerator
    extends HostNameBasedUniqueTicketIdGenerator {
        public ServiceTicketIdGenerator(int maxLength, String suffix) {
            super(maxLength, suffix);
        }
    }

    public static class TicketGrantingTicketIdGenerator
    extends HostNameBasedUniqueTicketIdGenerator {
        public TicketGrantingTicketIdGenerator(int maxLength, String suffix) {
            super(maxLength, suffix);
        }
    }
}

