/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint.cas.ticket.generator;

import com.connsec.web.authorize.endpoint.cas.ticket.generator.DefaultLongNumericGenerator;
import com.connsec.web.authorize.endpoint.cas.ticket.generator.DefaultRandomStringGenerator;
import com.connsec.web.authorize.endpoint.cas.ticket.generator.NumericGenerator;
import com.connsec.web.authorize.endpoint.cas.ticket.generator.RandomStringGenerator;
import com.connsec.web.authorize.endpoint.cas.ticket.generator.UniqueTicketIdGenerator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUniqueTicketIdGenerator
implements UniqueTicketIdGenerator {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private NumericGenerator numericGenerator;
    private RandomStringGenerator randomStringGenerator;
    private String suffix;

    public DefaultUniqueTicketIdGenerator() {
        this(35);
    }

    public DefaultUniqueTicketIdGenerator(int maxLength) {
        this(maxLength, null);
    }

    public DefaultUniqueTicketIdGenerator(int maxLength, String suffix) {
        this.setMaxLength(maxLength);
        this.setSuffix(suffix);
    }

    public DefaultUniqueTicketIdGenerator(NumericGenerator numericGenerator, RandomStringGenerator randomStringGenerator, String suffix) {
        this.randomStringGenerator = randomStringGenerator;
        this.numericGenerator = numericGenerator;
        this.setSuffix(suffix);
    }

    @Override
    public String getNewTicketId(String prefix) {
        String number = this.numericGenerator.getNextNumberAsString();
        StringBuilder buffer = new StringBuilder(prefix.length() + 2 + (StringUtils.isNotBlank((CharSequence)this.suffix) ? this.suffix.length() : 0) + this.randomStringGenerator.getMaxLength() + number.length());
        buffer.append(prefix);
        buffer.append('-');
        buffer.append(number);
        buffer.append('-');
        buffer.append(this.randomStringGenerator.getNewString());
        if (this.suffix != null) {
            buffer.append(this.suffix);
        }
        return buffer.toString();
    }

    public void setSuffix(String suffix) {
        this.suffix = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{suffix}) ? '-' + suffix : null;
    }

    public void setMaxLength(int maxLength) {
        this.randomStringGenerator = new DefaultRandomStringGenerator(maxLength);
        this.numericGenerator = new DefaultLongNumericGenerator(1L);
    }
}

