/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint.cas.ticket.generator;

import com.connsec.web.authorize.endpoint.cas.ticket.generator.LongNumericGenerator;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultLongNumericGenerator
implements LongNumericGenerator {
    private static final int MAX_STRING_LENGTH = Long.toString(Long.MAX_VALUE).length();
    private static final int MIN_STRING_LENGTH = 1;
    private AtomicLong count;

    public DefaultLongNumericGenerator() {
        this(0L);
    }

    public DefaultLongNumericGenerator(long initialValue) {
        this.count = new AtomicLong(initialValue);
    }

    @Override
    public long getNextLong() {
        return this.getNextValue();
    }

    @Override
    public String getNextNumberAsString() {
        return Long.toString(this.getNextValue());
    }

    @Override
    public int maxLength() {
        return MAX_STRING_LENGTH;
    }

    @Override
    public int minLength() {
        return 1;
    }

    protected long getNextValue() {
        if (this.count.compareAndSet(Long.MAX_VALUE, 0L)) {
            return Long.MAX_VALUE;
        }
        return this.count.getAndIncrement();
    }
}

