/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint;

import com.connsec.config.ApplicationConfig;
import com.connsec.dao.service.CasDetailsService;
import com.connsec.domain.BaseDomain;
import com.connsec.domain.apps.CasDetails;
import com.connsec.web.WebContext;
import com.connsec.web.authorize.endpoint.AuthorizeBaseEndpoint;
import com.connsec.web.authorize.endpoint.cas.ticket.ServiceTicketImpl;
import com.connsec.web.authorize.endpoint.cas.ticket.service.TicketServices;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class CasAuthorizeEndpoint
extends AuthorizeBaseEndpoint {
    static final Logger _logger = LoggerFactory.getLogger(CasAuthorizeEndpoint.class);
    @Autowired
    CasDetailsService casDetailsService;
    @Autowired
    ApplicationConfig applicationConfig;
    @Autowired
    @Qualifier(value="casTicketServices")
    TicketServices ticketServices;

    @RequestMapping(value={"/authz/cas/login"})
    public ModelAndView casLogin(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="service", required=false) String casService) {
        CasDetails casDetails = new CasDetails();
        casDetails.setService(casService);
        List casDetailsList = this.casDetailsService.query((BaseDomain)casDetails);
        casDetails = casDetailsList != null && casDetailsList.size() == 1 ? (CasDetails)casDetailsList.get(0) : null;
        return this.buildCasModelAndView(casDetails);
    }

    @RequestMapping(value={"/authz/cas/{id}"})
    public ModelAndView authorize(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="id") String id) {
        CasDetails casDetails = (CasDetails)this.casDetailsService.get(id);
        return this.buildCasModelAndView(casDetails);
    }

    private ModelAndView buildCasModelAndView(CasDetails casDetails) {
        _logger.debug("" + casDetails);
        WebContext.setAttribute((String)"CAS_AUTHORIZE_ENDPOINT_CAS_DETAILS", (Object)casDetails);
        WebContext.setAttribute((String)"single_sign_on_app_id", (Object)casDetails.getId());
        return WebContext.redirect((String)"/authz/cas/granting");
    }

    @RequestMapping(value={"/authz/cas/granting"})
    public ModelAndView grantingTicket(HttpServletRequest request, HttpServletResponse response) {
        CasDetails casDetails = (CasDetails)WebContext.getAttribute((String)"CAS_AUTHORIZE_ENDPOINT_CAS_DETAILS");
        ServiceTicketImpl serviceTicket = new ServiceTicketImpl(WebContext.getAuthentication(), casDetails);
        String ticket = this.ticketServices.createTicket(serviceTicket);
        return WebContext.redirect((String)(casDetails.getService() + "?" + "ticket" + "=" + ticket));
    }
}

