/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint;

import com.connsec.config.ApplicationConfig;
import com.connsec.constants.BOOLEAN;
import com.connsec.dao.service.CasDetailsService;
import com.connsec.dao.service.UserInfoService;
import com.connsec.domain.BaseDomain;
import com.connsec.domain.UserInfo;
import com.connsec.util.Instance;
import com.connsec.web.authorize.endpoint.AuthorizeBaseEndpoint;
import com.connsec.web.authorize.endpoint.adapter.AbstractAuthorizeAdapter;
import com.connsec.web.authorize.endpoint.cas.ticket.CasConstants;
import com.connsec.web.authorize.endpoint.cas.ticket.Ticket;
import com.connsec.web.authorize.endpoint.cas.ticket.service.TicketServices;
import com.connsec.web.authorize.endpoint.response.ServiceResponseBuilder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class Cas30AuthorizeEndpoint
extends AuthorizeBaseEndpoint {
    static final Logger _logger = LoggerFactory.getLogger(Cas30AuthorizeEndpoint.class);
    @Autowired
    CasDetailsService casDetailsService;
    @Autowired
    ApplicationConfig applicationConfig;
    @Autowired
    @Qualifier(value="userInfoService")
    private UserInfoService userInfoService;
    @Autowired
    @Qualifier(value="casTicketServices")
    TicketServices ticketServices;

    @RequestMapping(value={"/authz/cas/p3/serviceValidate"})
    @ResponseBody
    public String serviceValidate(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ticket") String ticket, @RequestParam(value="service") String service, @RequestParam(value="pgtUrl", required=false) String pgtUrl, @RequestParam(value="renew", required=false) String renew, @RequestParam(value="format", required=false, defaultValue="xml") String format) {
        Ticket storedTicket = this.ticketServices.consumeTicket(ticket);
        ServiceResponseBuilder serviceResponseBuilder = new ServiceResponseBuilder();
        if (storedTicket != null) {
            String principal = storedTicket.getAuthentication().getPrincipal().toString();
            serviceResponseBuilder.success().setUser(principal);
            if (BOOLEAN.isTrue((int)storedTicket.getCasDetails().getIsAdapter())) {
                AbstractAuthorizeAdapter adapter = (AbstractAuthorizeAdapter)Instance.newInstance((String)storedTicket.getCasDetails().getAdapter());
                UserInfo queryUserInfo = new UserInfo();
                queryUserInfo.setUsername(principal);
                UserInfo userInfo = (UserInfo)this.userInfoService.load((BaseDomain)queryUserInfo);
                adapter.generateInfo(userInfo, (Object)serviceResponseBuilder);
            }
        } else {
            serviceResponseBuilder.failure().setCode(CasConstants.ERROR_CODE.INVALID_TICKET).setDescription("Ticket " + ticket + " not recognized");
        }
        return serviceResponseBuilder.serviceResponseBuilder();
    }

    @RequestMapping(value={"/authz/cas/p3/proxyValidate"})
    @ResponseBody
    public String proxy(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ticket") String ticket, @RequestParam(value="service") String service, @RequestParam(value="pgtUrl", required=false) String pgtUrl, @RequestParam(value="renew", required=false) String renew, @RequestParam(value="format", required=false, defaultValue="xml") String format) {
        Ticket storedTicket = this.ticketServices.consumeTicket(ticket);
        ServiceResponseBuilder serviceResponseBuilder = new ServiceResponseBuilder();
        if (storedTicket != null) {
            String principal = storedTicket.getAuthentication().getPrincipal().toString();
            serviceResponseBuilder.success().setUser(principal);
            if (BOOLEAN.isTrue((int)storedTicket.getCasDetails().getIsAdapter())) {
                AbstractAuthorizeAdapter adapter = (AbstractAuthorizeAdapter)Instance.newInstance((String)storedTicket.getCasDetails().getAdapter());
                UserInfo queryUserInfo = new UserInfo();
                queryUserInfo.setUsername(principal);
                UserInfo userInfo = (UserInfo)this.userInfoService.load((BaseDomain)queryUserInfo);
                adapter.generateInfo(userInfo, (Object)serviceResponseBuilder);
            }
        } else {
            serviceResponseBuilder.failure().setCode(CasConstants.ERROR_CODE.INVALID_TICKET).setDescription("Ticket " + ticket + " not recognized");
        }
        return serviceResponseBuilder.serviceResponseBuilder();
    }
}

