/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint;

import com.connsec.config.ApplicationConfig;
import com.connsec.web.authorize.endpoint.AuthorizeBaseEndpoint;
import com.connsec.web.authorize.endpoint.cas.ticket.Ticket;
import com.connsec.web.authorize.endpoint.cas.ticket.service.TicketServices;
import com.connsec.web.authorize.endpoint.response.Service10ResponseBuilder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class Cas10AuthorizeEndpoint
extends AuthorizeBaseEndpoint {
    static final Logger _logger = LoggerFactory.getLogger(Cas10AuthorizeEndpoint.class);
    @Autowired
    ApplicationConfig applicationConfig;
    @Autowired
    @Qualifier(value="casTicketServices")
    TicketServices ticketServices;

    @RequestMapping(value={"/authz/cas/validate"})
    @ResponseBody
    public String validate(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ticket") String ticket, @RequestParam(value="service") String service, @RequestParam(value="renew", required=false) String renew) {
        Ticket storedTicket = this.ticketServices.consumeTicket(ticket);
        if (storedTicket != null) {
            return new Service10ResponseBuilder().success().setUser(storedTicket.getAuthentication().getPrincipal().toString()).serviceResponseBuilder();
        }
        return new Service10ResponseBuilder().failure().serviceResponseBuilder();
    }
}

