/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint.adapter;

import com.connsec.cert.CertSigner;
import com.connsec.constants.BOOLEAN;
import com.connsec.crypto.Base64Utils;
import com.connsec.crypto.PasswordReciprocal;
import com.connsec.crypto.ReciprocalUtils;
import com.connsec.domain.UserInfo;
import com.connsec.domain.apps.Applications;
import com.connsec.keystore.KeyStoreLoader;
import com.connsec.web.WebContext;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public abstract class AbstractAuthorizeAdapter {
    static final Logger _logger = LoggerFactory.getLogger(AbstractAuthorizeAdapter.class);
    public PasswordReciprocal passwordReciprocal = PasswordReciprocal.getInstance();

    public abstract ModelAndView authorize(UserInfo var1, Object var2, String var3, ModelAndView var4);

    public abstract String generateInfo(UserInfo var1, Object var2);

    public String sign(String data, Applications app) {
        if (BOOLEAN.isTrue((int)app.getIsSignature())) {
            KeyStoreLoader keyStoreLoader = (KeyStoreLoader)WebContext.getBean((String)"keyStoreLoader");
            try {
                byte[] signature = CertSigner.sign((byte[])data.getBytes(), (KeyStore)keyStoreLoader.getKeyStore(), (String)keyStoreLoader.getEntityName(), (String)keyStoreLoader.getKeystorePassword());
                _logger.debug("signed Token : " + data);
                _logger.debug("signature : " + signature.toString());
                data = Base64Utils.base64UrlEncode((byte[])data.getBytes("UTF-8")) + "." + Base64Utils.base64UrlEncode((byte[])signature);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            _logger.debug("Token : " + data);
        } else {
            _logger.debug("data not need sign .");
        }
        return data;
    }

    public String encrypt(String data, String algorithmKey, String algorithm) {
        algorithmKey = this.passwordReciprocal.decoder((CharSequence)algorithmKey);
        _logger.debug("algorithm : " + algorithm);
        _logger.debug("algorithmKey : " + algorithmKey);
        try {
            data = new String(Hex.encodeHex((byte[])data.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] encodeData = ReciprocalUtils.encode((String)data, (String)algorithmKey, (String)algorithm);
        String tokenString = Base64Utils.base64UrlEncode((byte[])encodeData);
        _logger.trace("Reciprocal then HEX  Token : " + tokenString);
        return tokenString;
    }
}

