/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint;

import com.connsec.client.oauth.builder.ServiceBuilder;
import com.connsec.client.oauth.builder.api.ConnsecApi20;
import com.connsec.client.oauth.oauth.OAuthService;
import com.connsec.dao.service.CasDetailsService;
import com.connsec.domain.apps.Applications;
import com.connsec.web.WebContext;
import com.connsec.web.authorize.endpoint.AuthorizeBaseEndpoint;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AuthorizeEndpoint
extends AuthorizeBaseEndpoint {
    @Autowired
    @Qualifier(value="oauth20JdbcClientDetailsService")
    private ClientDetailsService clientDetailsService;
    @Autowired
    CasDetailsService casDetailsService;

    @RequestMapping(value={"/authz/{id}"})
    public ModelAndView authorize(HttpServletRequest request, @PathVariable(value="id") String id) {
        ModelAndView modelAndView = null;
        Applications application = this.getApp(id);
        WebContext.setAttribute((String)"single_sign_on_app_id", (Object)id);
        if (application.getProtocol().equalsIgnoreCase("Extend_API")) {
            modelAndView = WebContext.forward((String)("/authz/api/" + id));
        } else if (application.getProtocol().equalsIgnoreCase("Form_Based")) {
            modelAndView = WebContext.forward((String)("/authz/formbased/" + id));
        } else if (application.getProtocol().equalsIgnoreCase("OAuth v2.0")) {
            ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(application.getId());
            OAuthService service = new ServiceBuilder().provider(ConnsecApi20.class).apiKey(application.getId()).apiSecret(application.getSecret()).callback(clientDetails.getRegisteredRedirectUri().toArray()[0].toString()).build();
            _logger.debug("" + clientDetails);
            String authorizationUrl = service.getAuthorizationUrl(null);
            modelAndView = WebContext.redirect((String)authorizationUrl);
        } else if (application.getProtocol().equalsIgnoreCase("OAuth v1.0a")) {
            modelAndView = WebContext.forward((String)("/authz/oauth10a/" + id));
        } else if (!application.getProtocol().equalsIgnoreCase("OpenID_Connect")) {
            if (application.getProtocol().equalsIgnoreCase("SAML v2.0")) {
                modelAndView = WebContext.forward((String)("/authz/saml20/idpinit/" + application.getId()));
            } else if (application.getProtocol().equalsIgnoreCase("SAML v1.1")) {
                modelAndView = WebContext.forward((String)("/authz/saml11/idpinit/" + application.getId()));
            } else if (application.getProtocol().equalsIgnoreCase("Token_Based")) {
                modelAndView = WebContext.forward((String)("/authorize/tokenbased/" + id));
            } else if (application.getProtocol().equalsIgnoreCase("LTPA")) {
                modelAndView = WebContext.forward((String)("/authz/ltpa/" + id));
            } else if (application.getProtocol().equalsIgnoreCase("CAS")) {
                modelAndView = WebContext.forward((String)("/authz/cas/" + id));
            } else if (application.getProtocol().equalsIgnoreCase("Desktop")) {
                modelAndView = WebContext.forward((String)("/authz/desktop/" + id));
            } else if (application.getProtocol().equalsIgnoreCase("Basic")) {
                modelAndView = WebContext.redirect((String)application.getLoginUrl());
            }
        }
        _logger.debug(modelAndView.getViewName());
        return modelAndView;
    }

    @RequestMapping(value={"/authz/oauth10a/{id}"})
    public ModelAndView authorizeOAuth10a(@PathVariable(value="id") String id) {
        String redirec_uri = this.getApp(id).getLoginUrl();
        return WebContext.redirect((String)redirec_uri);
    }
}

