/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint;

import com.connsec.crypto.ReciprocalUtils;
import com.connsec.domain.AppAccounts;
import com.connsec.domain.BaseDomain;
import com.connsec.domain.UserInfo;
import com.connsec.util.StringUtils;
import com.connsec.web.WebContext;
import com.connsec.web.authorize.endpoint.AuthorizeBaseEndpoint;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AuthorizeCredentialEndpoint
extends AuthorizeBaseEndpoint {
    @RequestMapping(value={"/authz/credential/forward"})
    public ModelAndView authorizeCredentialForward(@RequestParam(value="appId") String appId, @RequestParam(value="redirect_uri") String redirect_uri) {
        ModelAndView modelAndView = new ModelAndView("authorize/init_sso_credential");
        modelAndView.addObject("username", (Object)"");
        modelAndView.addObject("password", (Object)"");
        modelAndView.addObject("setpassword", (Object)true);
        modelAndView.addObject("uid", (Object)WebContext.getUserInfo().getId());
        modelAndView.addObject("appId", (Object)appId);
        modelAndView.addObject("redirect_uri", (Object)redirect_uri);
        return modelAndView;
    }

    @RequestMapping(value={"/authz/credential"})
    public ModelAndView authorizeCredential(HttpServletRequest request, @RequestParam(value="uid") String uid, @RequestParam(value="appId") String appId, @RequestParam(value="identity_username") String identity_username, @RequestParam(value="identity_password") String identity_password, @RequestParam(value="redirect_uri") String redirect_uri) {
        if (StringUtils.isNotEmpty((String)identity_username) && StringUtils.isNotEmpty((String)identity_password)) {
            AppAccounts appUser = new AppAccounts();
            UserInfo userInfo = WebContext.getUserInfo();
            appUser.genId();
            appUser.setUid(userInfo.getId());
            appUser.setUsername(userInfo.getUsername());
            appUser.setDisplayName(userInfo.getDisplayName());
            appUser.setAppId(appId);
            appUser.setAppName(this.getSessionApplication(appId).getName());
            appUser.setRelatedUsername(identity_username);
            appUser.setRelatedPassword(ReciprocalUtils.encode((String)identity_password));
            if (this.appAccountsService.insert((BaseDomain)appUser)) {
                // empty if block
            }
        }
        return WebContext.redirect((String)redirect_uri);
    }
}

