/*
 * Decompiled with CFR 0.152.
 */
package com.connsec.web.authorize.endpoint;

import com.connsec.crypto.ReciprocalUtils;
import com.connsec.dao.service.AppAccountsService;
import com.connsec.dao.service.ApplicationsService;
import com.connsec.domain.AppAccounts;
import com.connsec.domain.BaseDomain;
import com.connsec.domain.UserInfo;
import com.connsec.domain.apps.Applications;
import com.connsec.web.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.servlet.ModelAndView;

public class AuthorizeBaseEndpoint {
    static final Logger _logger = LoggerFactory.getLogger(AuthorizeBaseEndpoint.class);
    @Autowired
    @Qualifier(value="applicationsService")
    protected ApplicationsService applicationsService;
    @Autowired
    AppAccountsService appAccountsService;

    protected Applications getApp(String id) {
        Applications application = null;
        if (id.equals("manage")) {
            application = new Applications();
            application.setId("manage");
            application.setName("Manage App");
            application.setProtocol("Token_Based");
            application.setIsAdapter(1);
            application.setAdapter("com.connsec.web.authorize.endpoint.adapter.TokenBasedJWTAdapter");
        } else {
            application = (Applications)this.applicationsService.get(id);
        }
        if (application == null) {
            _logger.error("Applications for id " + id + "  is null");
        }
        WebContext.setAttribute((String)AuthorizeBaseEndpoint.class.getName(), (Object)application);
        return application;
    }

    protected Applications getSessionApplication(String id) {
        Object object = WebContext.getAttribute((String)AuthorizeBaseEndpoint.class.getName());
        Applications application = null;
        application = object != null ? (Applications)object : this.getApp(id);
        return application;
    }

    protected AppAccounts getAppAccounts(Applications application) {
        AppAccounts appAccount = new AppAccounts();
        UserInfo userInfo = WebContext.getUserInfo();
        if (application.getCredential() == 3) {
            appAccount = (AppAccounts)this.appAccountsService.load((BaseDomain)new AppAccounts(userInfo.getId(), application.getId()));
            if (appAccount != null) {
                appAccount.setRelatedPassword(ReciprocalUtils.decoder((String)appAccount.getRelatedPassword()));
            }
        } else if (application.getCredential() == 2) {
            appAccount.setRelatedUsername(application.getSharedUsername());
            appAccount.setRelatedPassword(ReciprocalUtils.decoder((String)application.getSharedPassword()));
        } else if (application.getCredential() == 1) {
            if (application.getSystemUserAttr().equalsIgnoreCase("uid")) {
                appAccount.setUsername(userInfo.getId());
            } else if (application.getSystemUserAttr().equalsIgnoreCase("username")) {
                appAccount.setUsername(userInfo.getUsername());
            } else if (application.getSystemUserAttr().equalsIgnoreCase("employeeNumber")) {
                appAccount.setUsername(userInfo.getEmployeeNumber());
            } else if (application.getSystemUserAttr().equalsIgnoreCase("email")) {
                appAccount.setUsername(userInfo.getEmail());
            } else if (application.getSystemUserAttr().equalsIgnoreCase("windowsAccount")) {
                appAccount.setUsername(userInfo.getWindowsAccount());
            }
            appAccount.setRelatedPassword(ReciprocalUtils.decoder((String)WebContext.getUserInfo().getDecipherable()));
        } else if (application.getCredential() == 0) {
            appAccount.setUsername(userInfo.getUsername());
            appAccount.setRelatedPassword(userInfo.getUsername());
        }
        return appAccount;
    }

    public ModelAndView generateInitCredentialModelAndView(String appId, String redirect_uri) {
        ModelAndView modelAndView = new ModelAndView("redirect:/authz/credential/forward?appId=" + appId + "&redirect_uri=" + redirect_uri);
        return modelAndView;
    }
}

