/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import edu.vt.middleware.crypt.x509.types.GeneralNameList;
import edu.vt.middleware.crypt.x509.types.ReasonFlags;

public class DistributionPoint {
    private static final int HASH_FACTOR = 31;
    private Object distributionPoint;
    private ReasonFlags reasons;
    private GeneralNameList cRLIssuer;

    public DistributionPoint() {
    }

    public DistributionPoint(String relativeName, ReasonFlags flags, GeneralNameList issuer) {
        if (issuer == null) {
            throw new IllegalArgumentException("CRL issuer name cannot be null when a relative name is used.");
        }
        this.distributionPoint = relativeName;
        this.reasons = flags;
        this.cRLIssuer = issuer;
    }

    public DistributionPoint(GeneralNameList names, ReasonFlags flags, GeneralNameList issuer) {
        this.distributionPoint = names;
        this.reasons = flags;
        this.cRLIssuer = issuer;
    }

    public Object getDistributionPoint() {
        return this.distributionPoint;
    }

    public ReasonFlags getReasons() {
        return this.reasons;
    }

    public GeneralNameList getCRLIssuer() {
        return this.cRLIssuer;
    }

    public String toString() {
        if (this.distributionPoint != null) {
            return this.distributionPoint.toString();
        }
        return "Empty Distribution Point";
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == this) {
            result = true;
        } else if (obj == null || obj.getClass() != this.getClass()) {
            result = false;
        } else {
            DistributionPoint other = (DistributionPoint)obj;
            result = (this.distributionPoint != null ? this.distributionPoint.equals(other.getDistributionPoint()) : other.getDistributionPoint() == null) && (this.reasons != null ? this.reasons.equals(other.getReasons()) : other.getReasons() == null) && (this.cRLIssuer != null ? this.cRLIssuer.equals(other.getCRLIssuer()) : other.getCRLIssuer() == null);
        }
        return result;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        if (this.distributionPoint != null) {
            hash = 31 * hash + this.distributionPoint.hashCode();
        }
        if (this.reasons != null) {
            hash = 31 * hash + this.reasons.hashCode();
        }
        if (this.cRLIssuer != null) {
            hash = 31 * hash + this.cRLIssuer.hashCode();
        }
        return hash;
    }
}

