/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import org.bouncycastle.util.Arrays;

public class BitString {
    protected static final int INT_BYTE_SIZE = 4;
    protected static final int BITS_IN_BYTE = 8;
    protected static final int UNSIGNED_BYTE_MASK = 255;
    private static final int HASH_FACTOR = 31;
    protected byte[] octets;

    public static byte[] getBytes(int bitString) {
        int bytes = 4;
        for (int i = 3; i >= 1 && (bitString & 255 << i * 8) == 0; --i) {
            --bytes;
        }
        byte[] data = new byte[bytes];
        for (int i = 0; i < bytes; ++i) {
            data[i] = (byte)(bitString >> i * 8 & 0xFF);
        }
        return data;
    }

    public byte[] getOctets() {
        return this.octets;
    }

    public int intValue() {
        int value = 0;
        for (int i = 0; i != this.octets.length && i != 4; ++i) {
            value |= (this.octets[i] & 0xFF) << 8 * i;
        }
        return value;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        result = obj == this ? true : (obj == null || obj.getClass() != this.getClass() ? false : Arrays.areEqual((byte[])this.octets, (byte[])((BitString)obj).getOctets()));
        return result;
    }

    public int hashCode() {
        return 31 * this.getClass().hashCode() + Arrays.hashCode((byte[])this.octets);
    }
}

