/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.pkcs;

import edu.vt.middleware.crypt.pkcs.PBES2Algorithm;
import edu.vt.middleware.crypt.symmetric.RC2;
import edu.vt.middleware.crypt.symmetric.SymmetricAlgorithm;
import edu.vt.middleware.crypt.util.DERHelper;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;

public class PBES2CipherGenerator {
    private PBES2Algorithm algorithm;
    private int keySize;
    private AlgorithmParameterSpec algParamSpec;

    public PBES2CipherGenerator(DERSequence seq) {
        this.algorithm = PBES2Algorithm.fromOid(((DERObjectIdentifier)seq.getObjectAt(0)).getId());
        DEREncodable parms = seq.getObjectAt(1);
        DERSequence pSeq = null;
        switch (this.algorithm) {
            case RC2: {
                pSeq = (DERSequence)parms;
                int effectiveBits = 32;
                int idx = 0;
                if (pSeq.size() > 1) {
                    idx = 1;
                    effectiveBits = RC2.getEffectiveBits(DERHelper.asInt(pSeq.getObjectAt(0)));
                    this.algParamSpec = new RC2ParameterSpec(effectiveBits, DERHelper.asOctets(pSeq.getObjectAt(idx)));
                }
                this.keySize = effectiveBits;
                break;
            }
            case RC5: {
                pSeq = (DERSequence)parms;
                int version = DERHelper.asInt(pSeq.getObjectAt(0));
                int rounds = DERHelper.asInt(pSeq.getObjectAt(1));
                int blkSize = DERHelper.asInt(pSeq.getObjectAt(2));
                this.algParamSpec = pSeq.size() > 3 ? new RC5ParameterSpec(version, rounds, blkSize, DERHelper.asOctets(pSeq.getObjectAt(3))) : new RC5ParameterSpec(version, rounds, blkSize);
                this.keySize = this.algorithm.getKeySize();
                break;
            }
            default: {
                this.algParamSpec = new IvParameterSpec(DERHelper.asOctets(parms));
                this.keySize = this.algorithm.getKeySize();
            }
        }
    }

    public SymmetricAlgorithm generate() {
        return SymmetricAlgorithm.newInstance(this.algorithm.getSpec(), this.algParamSpec);
    }

    public int getKeySize() {
        return this.keySize;
    }
}

