/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.io;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.CryptProvider;
import edu.vt.middleware.crypt.io.AbstractEncodedCredentialReader;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicKeyCredentialReader
extends AbstractEncodedCredentialReader<PublicKey> {
    @Override
    protected PublicKey decode(byte[] encoded) throws CryptException {
        try {
            String algorithm;
            ASN1Sequence seq = (ASN1Sequence)ASN1Object.fromByteArray((byte[])encoded);
            ASN1Sequence innerSeq = (ASN1Sequence)seq.getObjectAt(0);
            DEREncodable algId = innerSeq.getObjectAt(0);
            if (RSA_ID.equals((Object)algId)) {
                algorithm = "RSA";
            } else if (DSA_ID.equals((Object)algId)) {
                algorithm = "DSA";
            } else {
                throw new CryptException("Unsupported public key algorithm ID " + algId);
            }
            return CryptProvider.getKeyFactory(algorithm).generatePublic(new X509EncodedKeySpec(encoded));
        }
        catch (Exception e) {
            throw new CryptException("Invalid public key.", e);
        }
    }
}

