/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.digest;

import edu.vt.middleware.crypt.AbstractRandomizableAlgorithm;
import edu.vt.middleware.crypt.digest.MD2;
import edu.vt.middleware.crypt.digest.MD4;
import edu.vt.middleware.crypt.digest.MD5;
import edu.vt.middleware.crypt.digest.RipeMD128;
import edu.vt.middleware.crypt.digest.RipeMD160;
import edu.vt.middleware.crypt.digest.RipeMD256;
import edu.vt.middleware.crypt.digest.RipeMD320;
import edu.vt.middleware.crypt.digest.SHA1;
import edu.vt.middleware.crypt.digest.SHA256;
import edu.vt.middleware.crypt.digest.SHA384;
import edu.vt.middleware.crypt.digest.SHA512;
import edu.vt.middleware.crypt.digest.Tiger;
import edu.vt.middleware.crypt.digest.Whirlpool;
import edu.vt.middleware.crypt.util.Converter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.Digest;

public class DigestAlgorithm
extends AbstractRandomizableAlgorithm {
    public static final int CHUNK_SIZE = 4096;
    private static final Map<String, Class<? extends DigestAlgorithm>> NAME_CLASS_MAP = new HashMap<String, Class<? extends DigestAlgorithm>>();
    protected Digest digest;
    protected byte[] salt;

    protected DigestAlgorithm(Digest d) {
        this.setDigest(d);
    }

    public static DigestAlgorithm newInstance(String algorithm) {
        Class<? extends DigestAlgorithm> clazz = NAME_CLASS_MAP.get(algorithm.toUpperCase());
        if (clazz == null) {
            throw new IllegalArgumentException("Digest " + algorithm + " is not available.");
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    protected void setDigest(Digest d) {
        this.digest = d;
        this.algorithm = d.getAlgorithmName();
    }

    public void setSalt(byte[] randomBytes) {
        this.salt = randomBytes;
    }

    public byte[] getRandomSalt() {
        return this.getRandomData(this.getRandomByteSize());
    }

    public Digest getDigest() {
        return this.digest;
    }

    public byte[] digest(byte[] input) {
        if (this.salt != null) {
            this.digest.update(this.salt, 0, this.salt.length);
        }
        this.digest.update(input, 0, input.length);
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        return hash;
    }

    public String digest(byte[] input, Converter converter) {
        return converter.fromBytes(this.digest(input));
    }

    public byte[] digest(InputStream in) throws IOException {
        int count;
        if (in == null) {
            throw new IllegalArgumentException("Input stream cannot be null.");
        }
        byte[] buffer = new byte[4096];
        if (this.salt != null) {
            this.digest.update(this.salt, 0, this.salt.length);
        }
        while ((count = in.read(buffer, 0, 4096)) > 0) {
            this.digest.update(buffer, 0, count);
        }
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        return hash;
    }

    public String digest(InputStream in, Converter converter) throws IOException {
        return converter.fromBytes(this.digest(in));
    }

    static {
        NAME_CLASS_MAP.put("MD2", MD2.class);
        NAME_CLASS_MAP.put("MD4", MD4.class);
        NAME_CLASS_MAP.put("MD5", MD5.class);
        NAME_CLASS_MAP.put("RIPEMD128", RipeMD128.class);
        NAME_CLASS_MAP.put("RIPEMD160", RipeMD160.class);
        NAME_CLASS_MAP.put("RIPEMD256", RipeMD256.class);
        NAME_CLASS_MAP.put("RIPEMD320", RipeMD320.class);
        NAME_CLASS_MAP.put("SHA1", SHA1.class);
        NAME_CLASS_MAP.put("SHA-1", SHA1.class);
        NAME_CLASS_MAP.put("SHA256", SHA256.class);
        NAME_CLASS_MAP.put("SHA-256", SHA256.class);
        NAME_CLASS_MAP.put("SHA384", SHA384.class);
        NAME_CLASS_MAP.put("SHA-384", SHA384.class);
        NAME_CLASS_MAP.put("SHA512", SHA512.class);
        NAME_CLASS_MAP.put("SHA-512", SHA512.class);
        NAME_CLASS_MAP.put("TIGER", Tiger.class);
        NAME_CLASS_MAP.put("WHIRLPOOL", Whirlpool.class);
    }
}

