/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.asymmetric;

import edu.vt.middleware.crypt.AbstractEncryptionCli;
import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.asymmetric.AsymmetricAlgorithm;
import edu.vt.middleware.crypt.util.CryptReader;
import edu.vt.middleware.crypt.util.CryptWriter;
import java.io.File;
import java.io.IOException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class AsymmetricCli
extends AbstractEncryptionCli {
    protected static final String OPT_GENKEYPAIR = "genkeys";
    protected static final String OPT_PRIVKEYPATH = "privkey";
    private static final String COMMAND_NAME = "pkc";

    public static void main(String[] args) {
        new AsymmetricCli().performAction(args);
    }

    protected void initOptions() {
        super.initOptions();
        Option genKeyPair = new Option(OPT_GENKEYPAIR, true, "generate key pair of size; public key written to -out path, private key written to -privkey path");
        genKeyPair.setArgName("bitsize");
        genKeyPair.setOptionalArg(false);
        Option privKeyPath = new Option(OPT_PRIVKEYPATH, true, "output path of generated private key");
        privKeyPath.setArgName("filepath");
        Option encrypt = new Option("encrypt", true, "encrypt with X.509 DER-encoded public key or certificate");
        encrypt.setArgName("pubkeypath");
        encrypt.setOptionalArg(false);
        Option decrypt = new Option("decrypt", true, "decrypt with PKCS#8 DER-encoded private key");
        decrypt.setArgName("privkeypath");
        decrypt.setOptionalArg(false);
        this.options.addOption(genKeyPair);
        this.options.addOption(privKeyPath);
        this.options.addOption(encrypt);
        this.options.addOption(decrypt);
    }

    protected void dispatch(CommandLine line) throws Exception {
        if (line.hasOption("encrypt")) {
            this.encrypt(line);
        } else if (line.hasOption("decrypt")) {
            this.decrypt(line);
        } else if (line.hasOption(OPT_GENKEYPAIR)) {
            this.genKeyPair(line);
        } else {
            this.printHelp();
        }
    }

    protected AsymmetricAlgorithm newAlgorithm(CommandLine line) {
        if (!line.hasOption("cipher")) {
            throw new IllegalArgumentException("cipher is required.");
        }
        return AsymmetricAlgorithm.newInstance(line.getOptionValue("cipher"));
    }

    protected String getCommandName() {
        return COMMAND_NAME;
    }

    protected void encrypt(CommandLine line) throws Exception {
        this.validateOptions(line);
        AsymmetricAlgorithm alg = this.newAlgorithm(line);
        alg.setKey(this.readPublicKey(line));
        this.encrypt(alg, this.getInputStream(line), this.getOutputStream(line));
    }

    protected void decrypt(CommandLine line) throws Exception {
        this.validateOptions(line);
        AsymmetricAlgorithm alg = this.newAlgorithm(line);
        alg.setKey(this.readPrivateKey(line));
        this.decrypt(alg, this.getInputStream(line), this.getOutputStream(line));
    }

    protected void genKeyPair(CommandLine line) throws Exception {
        this.validateOptions(line);
        AsymmetricAlgorithm alg = this.newAlgorithm(line);
        int size = Integer.parseInt(line.getOptionValue(OPT_GENKEYPAIR));
        System.err.println("Generating " + alg + " key pair of " + size + " bits");
        KeyPair keyPair = alg.generateKeys(size);
        File pubKeyFile = new File(line.getOptionValue("out"));
        File privKeyFile = new File(line.getOptionValue(OPT_PRIVKEYPATH));
        CryptWriter.writeEncodedKey((Key)keyPair.getPublic(), pubKeyFile);
        System.err.println("Wrote X.509 DER-encoded public key to " + pubKeyFile);
        CryptWriter.writeEncodedKey((Key)keyPair.getPrivate(), privKeyFile);
        System.err.println("Wrote PKCS#8 DER-encoded private key to " + privKeyFile);
    }

    protected PublicKey readPublicKey(CommandLine line) throws Exception {
        PublicKey key = null;
        File keyFile = new File(line.getOptionValue("encrypt"));
        System.err.println("Reading public key from " + keyFile);
        try {
            key = CryptReader.readCertificate(keyFile).getPublicKey();
        }
        catch (Exception e) {
            key = CryptReader.readPublicKey(keyFile);
        }
        return key;
    }

    protected PrivateKey readPrivateKey(CommandLine line) throws CryptException, IOException {
        File keyFile = new File(line.getOptionValue("decrypt"));
        return CryptReader.readPrivateKey(keyFile);
    }

    protected void validateOptions(CommandLine line) {
        if (!line.hasOption("cipher")) {
            throw new IllegalArgumentException("cipher option is required.");
        }
        if (line.hasOption(OPT_GENKEYPAIR)) {
            if (!line.hasOption("out")) {
                throw new IllegalArgumentException("genkeys operation requires -out for public key output path");
            }
            if (!line.hasOption(OPT_PRIVKEYPATH)) {
                throw new IllegalArgumentException("genkeys operation requires -privkey for private key output path");
            }
        }
    }
}

