/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.SubtleUtil;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;

public final class RsaSsaPkcs1VerifyJce
implements PublicKeyVerify {
    private final RSAPublicKey publicKey;
    private final String signatureAlgorithm;

    public RsaSsaPkcs1VerifyJce(RSAPublicKey pubKey, Enums.HashType hash) throws GeneralSecurityException {
        this.publicKey = pubKey;
        this.signatureAlgorithm = SubtleUtil.toRsaSsaPkcs1Algo(hash);
    }

    @Override
    public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
        Signature verifier = EngineFactory.SIGNATURE.getInstance(this.signatureAlgorithm);
        verifier.initVerify(this.publicKey);
        verifier.update(data);
        boolean verified = false;
        try {
            verified = verifier.verify(signature);
        }
        catch (RuntimeException ex) {
            verified = false;
        }
        if (!verified) {
            throw new GeneralSecurityException("Invalid signature");
        }
    }
}

